/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.files;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.files.FilesProviderWithDirectoryString;
import org.anchoranalysis.io.input.bean.path.matcher.FilePathMatcher;
import org.anchoranalysis.io.input.bean.path.matcher.MatchExtensions;
import org.anchoranalysis.io.input.bean.path.matcher.MatchGlob;
import org.anchoranalysis.io.input.file.FilesProviderException;
import org.anchoranalysis.io.input.path.GlobExtractor;

public class SearchDirectory
extends FilesProviderWithDirectoryString {
    @BeanField
    private FilePathMatcher matcher = new MatchExtensions(ImageFileFormat.JPEG.getDefaultExtension());
    @BeanField
    private boolean recursive = false;
    @BeanField
    private int maxDirectoryDepth = -1;
    @BeanField
    private boolean ignoreHidden = true;
    @BeanField
    private boolean acceptDirectoryErrors = false;
    private boolean sort = true;

    public SearchDirectory(String directory) {
        this.setDirectory(directory);
    }

    @Override
    public List<File> matchingFilesForDirectory(Path directory, InputManagerParameters parameters) throws FilesProviderException {
        Optional maxDirectoryDepthOptional = OptionalFactory.create((this.maxDirectoryDepth >= 0 ? 1 : 0) != 0, (Object)this.maxDirectoryDepth);
        try {
            List filesUnsorted = (List)parameters.getExecutionTimeRecorder().recordExecutionTime("Searching filesystem for inputs", () -> this.searchMatchingFiles(directory, maxDirectoryDepthOptional, parameters));
            if (this.sort) {
                Collections.sort(filesUnsorted);
            }
            return filesUnsorted;
        }
        catch (InputReadFailedException e) {
            throw new FilesProviderException((Throwable)((Object)e));
        }
    }

    public void setFileFilterAndDirectory(Path combinedFileFilter) {
        GlobExtractor.GlobWithDirectory glob = GlobExtractor.extract(combinedFileFilter.toString());
        MatchGlob matcherGlob = new MatchGlob();
        matcherGlob.setGlob(glob.getGlob());
        this.setDirectory(glob.getDirectory().orElse(""));
        this.matcher = matcherGlob;
    }

    private List<File> searchMatchingFiles(Path directory, Optional<Integer> maxDirectoryDepthOptional, InputManagerParameters parameters) throws InputReadFailedException {
        return this.matcher.matchingFiles(directory, this.recursive, this.ignoreHidden, this.acceptDirectoryErrors, maxDirectoryDepthOptional, Optional.of(parameters));
    }

    public SearchDirectory() {
    }

    public FilePathMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(FilePathMatcher matcher) {
        this.matcher = matcher;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public int getMaxDirectoryDepth() {
        return this.maxDirectoryDepth;
    }

    public void setMaxDirectoryDepth(int maxDirectoryDepth) {
        this.maxDirectoryDepth = maxDirectoryDepth;
    }

    public boolean isIgnoreHidden() {
        return this.ignoreHidden;
    }

    public void setIgnoreHidden(boolean ignoreHidden) {
        this.ignoreHidden = ignoreHidden;
    }

    public boolean isAcceptDirectoryErrors() {
        return this.acceptDirectoryErrors;
    }

    public void setAcceptDirectoryErrors(boolean acceptDirectoryErrors) {
        this.acceptDirectoryErrors = acceptDirectoryErrors;
    }
}

