/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.files;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.files.FilesProviderWithDirectory;

public class SingleFile
extends FilesProviderWithDirectory {
    @BeanField
    private String path;
    private Path directory;

    public SingleFile(String path) {
        this.path = path;
    }

    @Override
    public List<File> matchingFilesForDirectory(Path directory, InputManagerParameters parameters) {
        File file = new File(this.path);
        if (this.hasDirectory()) {
            file = directory.resolve(file.getName()).toFile();
        }
        return Collections.singletonList(file);
    }

    @Override
    public Path getDirectoryAsPath(InputContextParameters inputContext) {
        if (this.hasDirectory()) {
            return this.directory;
        }
        return Paths.get(this.path, new String[0]).getParent();
    }

    private boolean hasDirectory() {
        return this.directory != null;
    }

    public SingleFile() {
    }

    public String getPath() {
        return this.path;
    }
}

