/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.files;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.primitive.StringList;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.system.path.CommonPath;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.files.FilesProvider;
import org.anchoranalysis.io.input.file.FilesProviderException;

public class SpecificPathList
extends FilesProvider {
    @BeanField
    @OptionalBean
    private StringList listPaths;
    @BeanField
    @OptionalBean
    private FilesProvider fallback;

    public SpecificPathList(List<String> listPaths) {
        this.listPaths = new StringList(listPaths);
    }

    public SpecificPathList(StringList listPaths) {
        this.listPaths = listPaths;
    }

    public static SpecificPathList createWithEmptyList() {
        SpecificPathList out = new SpecificPathList();
        out.listPaths = new StringList();
        return out;
    }

    @Override
    public List<File> create(InputManagerParameters parameters) throws FilesProviderException {
        Optional<List<String>> selectedPaths = this.selectListPaths(parameters.getInputContext());
        if (selectedPaths.isPresent()) {
            return SpecificPathList.matchingFilesForList(selectedPaths.get());
        }
        if (this.fallback != null) {
            return this.fallback.create(parameters);
        }
        throw SpecificPathList.exceptionIfUnspecified();
    }

    @Override
    public Optional<Path> rootDirectory(InputContextParameters inputContext) throws FilesProviderException {
        Optional<List<String>> selectedPaths = this.selectListPaths(inputContext);
        if (selectedPaths.isPresent()) {
            return CommonPath.fromStrings((Collection)selectedPaths.get());
        }
        if (this.fallback != null) {
            return this.fallback.rootDirectory(inputContext);
        }
        throw SpecificPathList.exceptionIfUnspecified();
    }

    private Optional<List<String>> selectListPaths(InputContextParameters inputContext) {
        if (this.listPaths != null) {
            return Optional.of(this.listPaths.asList());
        }
        return inputContext.getInputPaths().map(SpecificPathList::stringFromPaths);
    }

    private static FilesProviderException exceptionIfUnspecified() {
        return new FilesProviderException("No input-paths are specified, nor a fallback");
    }

    private static List<String> stringFromPaths(List<Path> paths) {
        return FunctionalList.mapToList(paths, Path::toString);
    }

    private static List<File> matchingFilesForList(List<String> listPaths) {
        return FunctionalList.mapToList(listPaths, File::new);
    }

    public SpecificPathList() {
    }

    public StringList getListPaths() {
        return this.listPaths;
    }

    public void setListPaths(StringList listPaths) {
        this.listPaths = listPaths;
    }

    public FilesProvider getFallback() {
        return this.fallback;
    }

    public void setFallback(FilesProvider fallback) {
        this.fallback = fallback;
    }
}

