/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path;

import java.nio.file.Path;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.io.input.path.ExtractPathElementRange;

public class NameElementRange
extends DerivePath {
    @BeanField
    private int indexStart = 0;
    @BeanField
    private int indexEnd = -2;
    private IndexRangeNegative indexRange;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        try {
            this.indexRange = new IndexRangeNegative(this.indexStart, this.indexEnd);
        }
        catch (OperationFailedException e) {
            throw new BeanMisconfiguredException("The indices are not correctly ordered", (Throwable)e);
        }
    }

    @Override
    public Path deriveFrom(Path source, boolean debugMode) throws DerivePathException {
        return ExtractPathElementRange.extract(source, this.indexRange);
    }

    public int getIndexStart() {
        return this.indexStart;
    }

    public void setIndexStart(int indexStart) {
        this.indexStart = indexStart;
    }

    public int getIndexEnd() {
        return this.indexEnd;
    }

    public void setIndexEnd(int indexEnd) {
        this.indexEnd = indexEnd;
    }
}

