/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path.matcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.io.input.bean.path.matcher.ConsumeMatchingFilesVisitor;
import org.anchoranalysis.io.input.path.matcher.DualPathPredicates;
import org.anchoranalysis.io.input.path.matcher.FindFilesException;

class FindMatchingFiles {
    public static List<File> search(Path directory, DualPathPredicates predicates, boolean recursive, Optional<Integer> maxDirectoryDepth) throws FindFilesException {
        LinkedList<File> out = new LinkedList<File>();
        try {
            Files.walkFileTree(directory, EnumSet.of(FileVisitOption.FOLLOW_LINKS), recursive ? maxDirectoryDepth.orElse(Integer.MAX_VALUE) : 1, new ConsumeMatchingFilesVisitor(predicates, out::add));
        }
        catch (AccessDeniedException e) {
            throw new FindFilesException(String.format("Cannot access directory: %s", e.getFile()));
        }
        catch (FileSystemException e) {
            throw new FindFilesException(String.format("An filesystem error occurring accessing directory: %s", e.getFile()));
        }
        catch (IOException e) {
            throw new FindFilesException(String.format("An IO error occurring accessing directory: %s", e.toString()));
        }
        return out;
    }

    private FindMatchingFiles() {
    }
}

