/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path.matcher;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.primitive.StringSet;
import org.anchoranalysis.core.collection.StringSetTrie;
import org.anchoranalysis.core.format.FormatExtensions;
import org.anchoranalysis.core.functional.checked.CheckedPredicate;
import org.anchoranalysis.core.system.path.ExtensionUtilities;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.bean.path.matcher.FilePathMatcher;

public class MatchExtensions
extends FilePathMatcher {
    @BeanField
    @OptionalBean
    private FilePathMatcher matcher;
    @BeanField
    private StringSet extensions = this.allExtensionsFromFormats();
    @BeanField
    private boolean prioritizeInputContext = false;

    public MatchExtensions(String ... extension) {
        this.extensions = new StringSet(extension);
    }

    @Override
    protected CheckedPredicate<Path, IOException> createMatcherFile(Path directory, Optional<InputContextParameters> inputContext) throws InputReadFailedException {
        StringSetTrie fileExtensions = this.fileExtensions(inputContext);
        if (this.matcher != null) {
            CheckedPredicate<Path, IOException> firstPred = this.matcher.createMatcherFile(directory, inputContext);
            return path -> firstPred.test(path) && this.matchesAnyExtension((Path)path, fileExtensions);
        }
        return path -> this.matchesAnyExtension((Path)path, fileExtensions);
    }

    @Override
    protected boolean canMatchSubdirectories() {
        return true;
    }

    private boolean matchesAnyExtension(Path path, StringSetTrie fileExtensions) {
        if (fileExtensions.isEmpty()) {
            return true;
        }
        Optional extension = ExtensionUtilities.extractExtension((Path)path);
        if (extension.isPresent()) {
            return fileExtensions.contains(((String)extension.get()).toLowerCase());
        }
        return false;
    }

    private StringSetTrie fileExtensions(Optional<InputContextParameters> inputContext) {
        if (this.prioritizeInputContext && inputContext.isPresent() && inputContext.get().getInputFilterExtensions().isPresent()) {
            return inputContext.get().getInputFilterExtensions().get();
        }
        return new StringSetTrie((Collection)this.extensions.set());
    }

    private StringSet allExtensionsFromFormats() {
        return new StringSet(Arrays.stream(FormatExtensions.allImageExtensions()).collect(Collectors.toSet()));
    }

    public MatchExtensions() {
    }

    public FilePathMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(FilePathMatcher matcher) {
        this.matcher = matcher;
    }

    public StringSet getExtensions() {
        return this.extensions;
    }

    public void setExtensions(StringSet extensions) {
        this.extensions = extensions;
    }

    public boolean isPrioritizeInputContext() {
        return this.prioritizeInputContext;
    }

    public void setPrioritizeInputContext(boolean prioritizeInputContext) {
        this.prioritizeInputContext = prioritizeInputContext;
    }
}

