/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path.matcher;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.function.Predicate;
import org.anchoranalysis.core.functional.checked.CheckedPredicate;
import org.anchoranalysis.core.system.path.PathDifference;
import org.anchoranalysis.core.system.path.PathDifferenceException;

class PredicateFromPathMatcher {
    public static CheckedPredicate<Path, IOException> create(Path directory, String filterType, String fileFilter, boolean filenameOnly) {
        PathMatcher matcher = directory.getFileSystem().getPathMatcher(filterType + ":" + fileFilter);
        return PredicateFromPathMatcher.predicateForPathMatcher(directory, matcher::matches, filenameOnly);
    }

    private static CheckedPredicate<Path, IOException> predicateForPathMatcher(Path directory, Predicate<Path> predicate, boolean filenameOnly) {
        if (filenameOnly) {
            return path -> PredicateFromPathMatcher.matchFilename(path, predicate);
        }
        return path -> PredicateFromPathMatcher.matchRelativePath(path, directory, predicate);
    }

    private static boolean matchRelativePath(Path path, Path directory, Predicate<Path> predicate) throws IOException {
        try {
            PathDifference difference = PathDifference.differenceFrom((Path)directory, (Path)path);
            return predicate.test(difference.combined());
        }
        catch (PathDifferenceException e) {
            throw new IOException(e);
        }
    }

    private static boolean matchFilename(Path path, Predicate<Path> predicate) {
        return predicate.test(path.getFileName());
    }

    private PredicateFromPathMatcher() {
    }
}

