/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.csv;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.io.input.csv.CSVReaderException;

public class CSVReader {
    private final String regularExpressionSeperator;
    private final boolean firstLineHeaders;
    private final boolean quotedStrings;
    private FileReader fileReader;
    private BufferedReader bufferedReader;
    private String[] headers;

    public CSVReader(String regularExpressionSeperator, boolean firstLineHeaders) {
        this(regularExpressionSeperator, firstLineHeaders, false);
    }

    public OpenedCSVFile read(Path filePath) throws CSVReaderException {
        if (!filePath.toFile().exists()) {
            throw new CSVReaderException("Failed to read CSV file as no file exists at " + filePath);
        }
        try {
            this.fileReader = new FileReader(filePath.toFile());
            this.bufferedReader = new BufferedReader(this.fileReader);
            OpenedCSVFile out = new OpenedCSVFile();
            if (this.firstLineHeaders) {
                String line = this.bufferedReader.readLine();
                if (line == null) {
                    throw new CSVReaderException("No header line found");
                }
                this.headers = line.split(this.regularExpressionSeperator);
                out.setNumberColumns(this.headers.length);
            }
            return out;
        }
        catch (IOException e) {
            throw new CSVReaderException(e);
        }
    }

    private static String maybeRemoveQuotes(String string) {
        if (string.length() <= 2) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public CSVReader(String regularExpressionSeperator, boolean firstLineHeaders, boolean quotedStrings) {
        this.regularExpressionSeperator = regularExpressionSeperator;
        this.firstLineHeaders = firstLineHeaders;
        this.quotedStrings = quotedStrings;
    }

    public class OpenedCSVFile
    implements AutoCloseable {
        private int numberColumns = -1;

        public Optional<String[]> readLine() throws IOException {
            String line = CSVReader.this.bufferedReader.readLine();
            if (line == null) {
                return Optional.empty();
            }
            String[] tokenized = line.split(CSVReader.this.regularExpressionSeperator);
            if (this.numberColumns == -1) {
                this.numberColumns = tokenized.length;
            }
            if (tokenized.length != this.numberColumns) {
                throw new IOException("Incorrect number of columns for line");
            }
            this.maybeRemoveQuotes(tokenized);
            return Optional.of(tokenized);
        }

        @Override
        public void close() throws CSVReaderException {
            try {
                if (CSVReader.this.fileReader != null) {
                    CSVReader.this.fileReader.close();
                    CSVReader.this.fileReader = null;
                }
            }
            catch (IOException e) {
                throw new CSVReaderException(e);
            }
        }

        public boolean hasHeaders() {
            return CSVReader.this.firstLineHeaders;
        }

        public String[] getHeaders() {
            return CSVReader.this.headers;
        }

        private void maybeRemoveQuotes(String[] arr) {
            if (!CSVReader.this.quotedStrings) {
                return;
            }
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = CSVReader.maybeRemoveQuotes(arr[i]);
            }
        }

        public void setNumberColumns(int numberColumns) {
            this.numberColumns = numberColumns;
        }
    }
}

