/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.csv;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.io.input.csv.CSVReader;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.csv.ProcessCSVLine;

public class ReadByLine
implements AutoCloseable {
    private final Path filePath;
    private final CSVReader csvReader;
    private CSVReader.OpenedCSVFile openedFile = null;

    public String[] headers() throws CSVReaderException {
        this.openIfNecessary();
        return this.openedFile.getHeaders();
    }

    public int read(ProcessCSVLine lineProcessor) throws CSVReaderException {
        try {
            Optional<String[]> line;
            this.openIfNecessary();
            boolean firstLine = true;
            int count = 0;
            while ((line = this.openedFile.readLine()).isPresent()) {
                lineProcessor.processLine(line.get(), firstLine);
                firstLine = false;
                ++count;
            }
            int n = count;
            return n;
        }
        catch (IOException | OperationFailedException e) {
            throw new CSVReaderException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() throws CSVReaderException {
        if (this.openedFile != null) {
            this.openedFile.close();
            this.openedFile = null;
        }
    }

    private void openIfNecessary() throws CSVReaderException {
        if (this.openedFile == null) {
            this.openedFile = this.csvReader.read(this.filePath);
        }
    }

    public ReadByLine(Path filePath, CSVReader csvReader) {
        this.filePath = filePath;
        this.csvReader = csvReader;
    }
}

