/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.file;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.core.log.Logger;

public final class FileNamerContext {
    private static final String DEFAULT_ELSE_NAME = "unknownName";
    private final Optional<Path> inputDirectory;
    private final boolean relativeToDirectory;
    private final String elseName;
    private final Optional<IndexRangeNegative> nameSubrange;
    private final Logger logger;

    public FileNamerContext(Logger logger) {
        this(Optional.empty(), false, Optional.empty(), logger);
    }

    public FileNamerContext(Optional<Path> inputDirectory, boolean relativeToDirectory, Optional<IndexRangeNegative> nameSubrange, Logger logger) {
        this(inputDirectory, relativeToDirectory, DEFAULT_ELSE_NAME, nameSubrange, logger);
    }

    public FileNamerContext(String elseName, Logger logger) {
        this(Optional.empty(), false, elseName, Optional.empty(), logger);
    }

    public Optional<Path> getInputDirectory() {
        return this.inputDirectory;
    }

    public boolean isRelativeToDirectory() {
        return this.relativeToDirectory;
    }

    public String getElseName() {
        return this.elseName;
    }

    public Optional<IndexRangeNegative> getNameSubrange() {
        return this.nameSubrange;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileNamerContext)) {
            return false;
        }
        FileNamerContext other = (FileNamerContext)o;
        if (this.isRelativeToDirectory() != other.isRelativeToDirectory()) {
            return false;
        }
        Optional<Path> this$inputDirectory = this.getInputDirectory();
        Optional<Path> other$inputDirectory = other.getInputDirectory();
        if (this$inputDirectory == null ? other$inputDirectory != null : !((Object)this$inputDirectory).equals(other$inputDirectory)) {
            return false;
        }
        String this$elseName = this.getElseName();
        String other$elseName = other.getElseName();
        if (this$elseName == null ? other$elseName != null : !this$elseName.equals(other$elseName)) {
            return false;
        }
        Optional<IndexRangeNegative> this$nameSubrange = this.getNameSubrange();
        Optional<IndexRangeNegative> other$nameSubrange = other.getNameSubrange();
        if (this$nameSubrange == null ? other$nameSubrange != null : !((Object)this$nameSubrange).equals(other$nameSubrange)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRelativeToDirectory() ? 79 : 97);
        Optional<Path> $inputDirectory = this.getInputDirectory();
        result = result * 59 + ($inputDirectory == null ? 43 : ((Object)$inputDirectory).hashCode());
        String $elseName = this.getElseName();
        result = result * 59 + ($elseName == null ? 43 : $elseName.hashCode());
        Optional<IndexRangeNegative> $nameSubrange = this.getNameSubrange();
        result = result * 59 + ($nameSubrange == null ? 43 : ((Object)$nameSubrange).hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public String toString() {
        return "FileNamerContext(inputDirectory=" + this.getInputDirectory() + ", relativeToDirectory=" + this.isRelativeToDirectory() + ", elseName=" + this.getElseName() + ", nameSubrange=" + this.getNameSubrange() + ", logger=" + this.getLogger() + ")";
    }

    public FileNamerContext(Optional<Path> inputDirectory, boolean relativeToDirectory, String elseName, Optional<IndexRangeNegative> nameSubrange, Logger logger) {
        this.inputDirectory = inputDirectory;
        this.relativeToDirectory = relativeToDirectory;
        this.elseName = elseName;
        this.nameSubrange = nameSubrange;
        this.logger = logger;
    }
}

