/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.file;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import org.anchoranalysis.io.input.file.NamedFile;
import org.anchoranalysis.io.input.file.SingleFileInputBase;

public class FileWithDirectoryInput
extends SingleFileInputBase {
    private Path directory;

    public FileWithDirectoryInput(NamedFile file, Path directory) {
        super(file);
        Preconditions.checkArgument((boolean)directory.toFile().isDirectory());
        Preconditions.checkArgument((boolean)file.getPath().toAbsolutePath().normalize().startsWith(directory));
        this.directory = directory;
    }

    public Path getDirectory() {
        return this.directory;
    }
}

