/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.file;

import java.io.File;
import java.nio.file.Path;
import java.util.function.BiFunction;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;

public final class NamedFile {
    private final String identifier;
    private final File file;

    public NamedFile(String identifier, File file) {
        this.identifier = identifier;
        this.file = file;
        if (identifier.startsWith(" ") || identifier.endsWith(" ")) {
            throw new AnchorFriendlyRuntimeException("An identifier is not permitted to begin or end with whitespace: " + identifier);
        }
    }

    public Path getPath() {
        return this.file.toPath();
    }

    public NamedFile mapIdentifier(BiFunction<String, File, String> function) {
        return new NamedFile(function.apply(this.identifier, this.file), this.file);
    }

    public Path toPath() {
        return this.file.toPath();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedFile)) {
            return false;
        }
        NamedFile other = (NamedFile)o;
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }

    public String toString() {
        return "NamedFile(identifier=" + this.getIdentifier() + ", file=" + this.getFile() + ")";
    }
}

