/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input;

import com.google.common.base.Preconditions;
import io.vavr.control.Either;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.anchoranalysis.core.collection.StringSetTrie;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.io.input.bean.DebugModeParameters;

public class InputContextParameters {
    private Optional<List<Path>> inputPaths = Optional.empty();
    private Optional<Path> inputDirectory = Optional.empty();
    private Optional<String> inputFilterGlob = Optional.empty();
    private Optional<StringSetTrie> inputFilterExtensions = Optional.empty();
    private Optional<DebugModeParameters> debugModeParameters = Optional.empty();
    private boolean relativeForIdentifier = false;
    private boolean shuffle = false;
    private Optional<Either<Integer, Double>> limitUpper = Optional.empty();
    private Optional<IndexRangeNegative> identifierSubrange = Optional.empty();

    public void setInputDirectory(Optional<Path> inputDirectory) throws IOException {
        OptionalUtilities.ifPresent(inputDirectory, InputContextParameters::checkAbsolutePath);
        this.inputDirectory = inputDirectory;
    }

    public void assignInputDirectory(Optional<Path> inputDirectory) {
        this.inputDirectory = inputDirectory.map(InputContextParameters::normalizeDirectory);
    }

    public void assignFilterGlob(String glob) {
        this.inputFilterGlob = Optional.of(glob);
    }

    public void assignIdentifierSubrange(IndexRangeNegative identifierSubrange) {
        this.identifierSubrange = Optional.of(identifierSubrange);
    }

    public void assignInputFilterExtensionsIfMissing(Supplier<Optional<StringSetTrie>> filterExtensions) {
        if (!this.inputFilterExtensions.isPresent()) {
            this.inputFilterExtensions = filterExtensions.get();
        }
    }

    public void assignInputFilterExtensions(StringSetTrie filterExtensions) {
        this.inputFilterExtensions = Optional.of(filterExtensions);
    }

    public void assignRelativeForIdentifier() {
        this.relativeForIdentifier = true;
    }

    public void assignFixedLimit(int fixedLimit) {
        this.limitUpper = Optional.of(Either.left((Object)fixedLimit));
    }

    public void assignRatioLimit(double ratioLimit) {
        Preconditions.checkArgument((ratioLimit > 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((ratioLimit < 1.0 ? 1 : 0) != 0);
        this.limitUpper = Optional.of(Either.right((Object)ratioLimit));
    }

    public void assignPaths(List<Path> paths) {
        this.inputPaths = Optional.of(paths);
    }

    public void assignShuffle() {
        this.shuffle = true;
    }

    private static void checkAbsolutePath(Path inputDirectory) throws IOException {
        if (!inputDirectory.isAbsolute()) {
            throw new IOException(String.format("An non-absolute path was passed to setInputDirectory() of %s", inputDirectory));
        }
    }

    private static Path normalizeDirectory(Path directory) {
        if (!directory.isAbsolute()) {
            return directory.toAbsolutePath().normalize();
        }
        return directory.normalize();
    }

    @Generated
    public Optional<List<Path>> getInputPaths() {
        return this.inputPaths;
    }

    @Generated
    public void setInputPaths(Optional<List<Path>> inputPaths) {
        this.inputPaths = inputPaths;
    }

    @Generated
    public Optional<Path> getInputDirectory() {
        return this.inputDirectory;
    }

    @Generated
    public Optional<String> getInputFilterGlob() {
        return this.inputFilterGlob;
    }

    @Generated
    public void setInputFilterGlob(Optional<String> inputFilterGlob) {
        this.inputFilterGlob = inputFilterGlob;
    }

    @Generated
    public Optional<StringSetTrie> getInputFilterExtensions() {
        return this.inputFilterExtensions;
    }

    @Generated
    public void setInputFilterExtensions(Optional<StringSetTrie> inputFilterExtensions) {
        this.inputFilterExtensions = inputFilterExtensions;
    }

    @Generated
    public Optional<DebugModeParameters> getDebugModeParameters() {
        return this.debugModeParameters;
    }

    @Generated
    public void setDebugModeParameters(Optional<DebugModeParameters> debugModeParameters) {
        this.debugModeParameters = debugModeParameters;
    }

    @Generated
    public boolean isRelativeForIdentifier() {
        return this.relativeForIdentifier;
    }

    @Generated
    public void setRelativeForIdentifier(boolean relativeForIdentifier) {
        this.relativeForIdentifier = relativeForIdentifier;
    }

    @Generated
    public boolean isShuffle() {
        return this.shuffle;
    }

    @Generated
    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    @Generated
    public Optional<Either<Integer, Double>> getLimitUpper() {
        return this.limitUpper;
    }

    @Generated
    public void setLimitUpper(Optional<Either<Integer, Double>> limitUpper) {
        this.limitUpper = limitUpper;
    }

    @Generated
    public Optional<IndexRangeNegative> getIdentifierSubrange() {
        return this.identifierSubrange;
    }

    @Generated
    public void setIdentifierSubrange(Optional<IndexRangeNegative> identifierSubrange) {
        this.identifierSubrange = identifierSubrange;
    }
}

