/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.io.input.FindNonInputFiles;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.file.NamedFile;

public class InputsWithDirectory<T extends InputFromManager> {
    private List<T> inputs;
    private Optional<Path> directory;

    public InputsWithDirectory(List<T> inputs) {
        this(new ArrayList<T>(inputs), Optional.empty());
    }

    public InputsWithDirectory(List<T> inputs, Optional<Path> directory) {
        this.inputs = new ArrayList<T>(inputs);
        this.directory = directory;
    }

    public <S extends InputFromManager> InputsWithDirectory<S> map(Function<T, S> mapFunction) {
        return new InputsWithDirectory<T>(FunctionalList.mapToList(this.inputs, mapFunction), this.directory);
    }

    public <S extends InputFromManager, E extends Exception> InputsWithDirectory<S> map(CheckedFunction<T, S, E> mapFunction, Class<? extends E> throwableClass) throws E {
        return new InputsWithDirectory<T>(FunctionalList.mapToList(this.inputs, throwableClass, mapFunction), this.directory);
    }

    public <S extends InputFromManager> InputsWithDirectory<S> withInputs(List<S> inputsToAssign) {
        return new InputsWithDirectory<S>(inputsToAssign, this.directory);
    }

    public Collection<NamedFile> findAllNonInputFiles() throws OperationFailedException {
        if (this.directory.isPresent()) {
            return FindNonInputFiles.from(this.directory.get(), this.inputs);
        }
        throw new OperationFailedException("A directory is not defined, so this operation is not possible.");
    }

    public boolean isEmpty() {
        return this.inputs.isEmpty();
    }

    public Iterator<T> iterator() {
        return this.inputs.iterator();
    }

    public ListIterator<T> listIterator() {
        return this.inputs.listIterator();
    }

    @Generated
    public List<T> inputs() {
        return this.inputs;
    }

    @Generated
    public Optional<Path> directory() {
        return this.directory;
    }
}

