/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.dictionary;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.bean.files.FilesProvider;
import org.anchoranalysis.io.input.file.FilesProviderException;

public class ReadFromFile
extends DictionaryProvider {
    @BeanField
    private FilesProvider files;

    public Dictionary get() throws ProvisionFailedException {
        try {
            List<File> providedFiles = this.files.create(new InputManagerParameters(this.getLogger()));
            if (providedFiles.isEmpty()) {
                throw new ProvisionFailedException("No files are provided");
            }
            if (providedFiles.size() > 1) {
                throw new ProvisionFailedException("More than one file is provided");
            }
            Path filePath = ((File)providedFiles.iterator().next()).toPath();
            return Dictionary.readFromFile((Path)filePath);
        }
        catch (IOException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
        catch (FilesProviderException e) {
            throw new ProvisionFailedException("Cannot find files", (Throwable)((Object)e));
        }
    }

    @Generated
    public FilesProvider getFiles() {
        return this.files;
    }

    @Generated
    public void setFiles(FilesProvider files) {
        this.files = files;
    }
}

