/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.namer;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.io.input.bean.namer.FileNamer;
import org.anchoranalysis.io.input.file.FileNamerContext;
import org.anchoranalysis.io.input.file.NamedFile;

public abstract class FileNamerIndependent
extends FileNamer {
    @Override
    public List<NamedFile> deriveName(List<File> files, FileNamerContext context) {
        ArrayList<NamedFile> out = new ArrayList<NamedFile>();
        int index = 0;
        for (File file : files) {
            String name = this.deriveNameOrElse(file, index++, context);
            out.add(new NamedFile(name, file));
        }
        return out;
    }

    protected abstract String deriveName(File var1, Optional<Path> var2, int var3) throws CreateException;

    private String deriveNameOrElse(File file, int index, FileNamerContext context) {
        try {
            return this.deriveName(file, context.getInputDirectory(), index);
        }
        catch (CreateException e) {
            String elseNameWithIndex = String.format("%s04%d", context.getElseName(), index);
            context.getLogger().errorReporter().recordErrorFormatted(FileNamerIndependent.class, "Cannot create a name for file %s and index %d. Using '%s' instead.", new Object[]{file.getPath(), index, elseNameWithIndex});
            return elseNameWithIndex;
        }
    }
}

