/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path.matcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.io.input.path.matcher.DualPathPredicates;

class ConsumeMatchingFilesVisitor
extends SimpleFileVisitor<Path> {
    private DualPathPredicates predicates;
    private Consumer<File> consumer;

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (attrs.isRegularFile() && !attrs.isDirectory() && this.predicates.matchFile(file)) {
            this.consumer.accept(file.normalize().toFile());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.predicates.getDirectory().test((Object)dir)) {
            return super.preVisitDirectory(dir, attrs);
        }
        return FileVisitResult.SKIP_SUBTREE;
    }

    @Generated
    public ConsumeMatchingFilesVisitor(DualPathPredicates predicates, Consumer<File> consumer) {
        this.predicates = predicates;
        this.consumer = consumer;
    }
}

