/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path.matcher;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributes;
import lombok.Generated;
import org.apache.commons.lang.SystemUtils;

class HiddenPathChecker {
    public static boolean includePath(Path path) {
        try {
            return !path.toFile().exists() || !HiddenPathChecker.isHidden(path);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean isHidden(Path path) throws IOException {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                DosFileAttributes dosFileAttributes = Files.readAttributes(path, DosFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                return dosFileAttributes.isHidden();
            }
            return HiddenPathChecker.fallbackIsHidden(path);
        }
        catch (UnsupportedOperationException e) {
            return HiddenPathChecker.fallbackIsHidden(path);
        }
    }

    private static boolean fallbackIsHidden(Path path) throws IOException {
        String pathAsString = path.toString();
        if (pathAsString.equals(".") || pathAsString.equals("..")) {
            return false;
        }
        return Files.isHidden(path);
    }

    @Generated
    private HiddenPathChecker() {
    }
}

