/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean.path.matcher;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.functional.checked.CheckedPredicate;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.bean.path.matcher.FilePathMatcher;
import org.anchoranalysis.io.input.bean.path.matcher.PredicateFromPathMatcher;

public class MatchGlob
extends FilePathMatcher {
    @BeanField
    @AllowEmpty
    private String glob = "";

    @Override
    protected CheckedPredicate<Path, IOException> createMatcherFile(Path directory, Optional<InputContextParameters> inputContext) throws InputReadFailedException {
        Optional<String> globString = this.globString(inputContext);
        if (globString.isPresent()) {
            return PredicateFromPathMatcher.create(directory, "glob", globString.get(), !this.canMatchSubdirectories());
        }
        return path -> true;
    }

    @Override
    protected boolean canMatchSubdirectories() {
        return this.glob.contains("**");
    }

    private Optional<String> globString(Optional<InputContextParameters> inputContext) throws InputReadFailedException {
        if (!this.glob.isEmpty()) {
            return Optional.of(this.glob);
        }
        if (inputContext.isPresent()) {
            return inputContext.get().getInputFilterGlob();
        }
        throw new InputReadFailedException("Neither a glob is defined as a bean-field, nor as part of the input-context parameters. At least one must be defined.");
    }

    @Generated
    public MatchGlob() {
    }

    @Generated
    public MatchGlob(String glob) {
        this.glob = glob;
    }

    @Generated
    public String getGlob() {
        return this.glob;
    }

    @Generated
    public void setGlob(String glob) {
        this.glob = glob;
    }
}

