/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.path;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.io.input.path.DerivePathException;

public class ExtractPathElementRange {
    public static Path extract(Path path, IndexRangeNegative range) throws DerivePathException {
        try {
            List elementsSubrange = range.extract(path.getNameCount(), path::getName);
            if (!elementsSubrange.isEmpty()) {
                return ExtractPathElementRange.getFile(elementsSubrange).toPath();
            }
            throw new DerivePathException(String.format("No element exists in the range %s for path %s:", range, path));
        }
        catch (OperationFailedException e) {
            throw new DerivePathException("Cannot extract a subrange of elements from the path: " + String.valueOf(path), e);
        }
    }

    private static File getFile(Collection<Path> elements) throws DerivePathException {
        File file = null;
        for (Path name : elements) {
            if (file == null) {
                file = new File(name.toString());
                continue;
            }
            file = new File(file, name.toString());
        }
        if (file != null) {
            return file;
        }
        throw new DerivePathException("Zero paths elements exist in the range, so a file cannot be constructed.");
    }

    @Generated
    private ExtractPathElementRange() {
    }
}

