/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.path;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.system.path.FilePathToUnixStyleConverter;

public class GlobExtractor {
    public static GlobWithDirectory extract(String wildcardString) {
        String str = FilePathToUnixStyleConverter.toStringUnixStyle((String)wildcardString);
        int finalSlash = GlobExtractor.positionFinalSlashBeforeWildcard(str);
        if (finalSlash == -1) {
            return new GlobWithDirectory(Optional.empty(), str);
        }
        return new GlobWithDirectory(Optional.of(str.substring(0, finalSlash + 1)), str.substring(finalSlash + 1));
    }

    private static int positionFinalSlashBeforeWildcard(String withWildcard) {
        int firstWildcardPosition = withWildcard.indexOf(42);
        String without = withWildcard.substring(0, firstWildcardPosition);
        return without.lastIndexOf(47);
    }

    @Generated
    private GlobExtractor() {
    }

    public static final class GlobWithDirectory {
        private final Optional<String> directory;
        private final String glob;

        @Generated
        public Optional<String> getDirectory() {
            return this.directory;
        }

        @Generated
        public String getGlob() {
            return this.glob;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GlobWithDirectory)) {
                return false;
            }
            GlobWithDirectory other = (GlobWithDirectory)o;
            Optional<String> this$directory = this.getDirectory();
            Optional<String> other$directory = other.getDirectory();
            if (this$directory == null ? other$directory != null : !((Object)this$directory).equals(other$directory)) {
                return false;
            }
            String this$glob = this.getGlob();
            String other$glob = other.getGlob();
            return !(this$glob == null ? other$glob != null : !this$glob.equals(other$glob));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $directory = this.getDirectory();
            result = result * 59 + ($directory == null ? 43 : ((Object)$directory).hashCode());
            String $glob = this.getGlob();
            result = result * 59 + ($glob == null ? 43 : $glob.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GlobExtractor.GlobWithDirectory(directory=" + String.valueOf(this.getDirectory()) + ", glob=" + this.getGlob() + ")";
        }

        @Generated
        public GlobWithDirectory(Optional<String> directory, String glob) {
            this.directory = directory;
            this.glob = glob;
        }
    }
}

