/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.bean.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.primitive.StringSet;
import org.anchoranalysis.io.output.bean.enabled.OutputEnabled;
import org.anchoranalysis.io.output.bean.rules.OutputEnabledRules;
import org.anchoranalysis.io.output.bean.rules.Permissive;
import org.anchoranalysis.io.output.enabled.single.SingleLevelOutputEnabled;

public abstract class OutputEnableRulesSpecify
extends OutputEnabledRules {
    @BeanField
    @OptionalBean
    private StringSet first;
    @BeanField
    private List<NamedBean<StringSet>> second = Arrays.asList(new NamedBean[0]);
    private Map<String, SingleLevelOutputEnabled> mapSecondLevel = null;

    protected OutputEnableRulesSpecify(StringSet first) {
        this.first = first;
    }

    protected boolean firstLevelContains(String outputName) {
        return this.first != null && this.first.contains(outputName);
    }

    protected abstract SingleLevelOutputEnabled createSecondLevelFromSet(StringSet var1);

    protected SingleLevelOutputEnabled secondLevelOutputs(String outputName, OutputEnabled defaultValue) {
        if (this.second.isEmpty()) {
            return new Permissive().create(Optional.empty());
        }
        this.createSecondLevelMapIfNecessary();
        return this.mapSecondLevel.getOrDefault(outputName, defaultValue);
    }

    protected boolean isFirstDefined() {
        return this.first != null;
    }

    private void createSecondLevelMapIfNecessary() {
        if (this.mapSecondLevel == null) {
            this.mapSecondLevel = this.createSecondLevelMap();
        }
    }

    private Map<String, SingleLevelOutputEnabled> createSecondLevelMap() {
        HashMap<String, SingleLevelOutputEnabled> map = new HashMap<String, SingleLevelOutputEnabled>();
        for (NamedBean<StringSet> bean : this.second) {
            map.put(bean.getName(), this.createSecondLevelFromSet((StringSet)bean.getItem()));
        }
        return map;
    }

    protected OutputEnableRulesSpecify() {
    }

    public StringSet getFirst() {
        return this.first;
    }

    public void setFirst(StringSet first) {
        this.first = first;
    }

    public List<NamedBean<StringSet>> getSecond() {
        return this.second;
    }

    public void setSecond(List<NamedBean<StringSet>> second) {
        this.second = second;
    }
}

