/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.namestyle;

import com.google.common.base.Preconditions;
import org.anchoranalysis.io.output.namestyle.IndexableOutputNameStyle;

public class IntegerSuffixOutputNameStyle
extends IndexableOutputNameStyle {
    private static final long serialVersionUID = 0L;
    private String prefix;
    private int numberDigits;

    public IntegerSuffixOutputNameStyle() {
    }

    public IntegerSuffixOutputNameStyle(String outputName, int numberDigits) {
        super(outputName);
        Preconditions.checkArgument((numberDigits > 1 ? 1 : 0) != 0);
        this.numberDigits = numberDigits;
    }

    public IntegerSuffixOutputNameStyle(String outputName, String prefix, int numberDigits) {
        this(outputName, numberDigits);
        this.prefix = prefix;
    }

    private IntegerSuffixOutputNameStyle(IntegerSuffixOutputNameStyle src) {
        super(src);
        this.prefix = src.prefix;
        this.numberDigits = src.numberDigits;
    }

    @Override
    public IndexableOutputNameStyle duplicate() {
        return new IntegerSuffixOutputNameStyle(this);
    }

    @Override
    protected String filenameFromOutputFormatString(String outputFormatString, String index) {
        int indexInt = Integer.parseInt(index);
        return String.format(outputFormatString, indexInt);
    }

    @Override
    protected String outputFormatString() {
        return this.combineIntegerAndOutputName(IntegerSuffixOutputNameStyle.integerFormatSpecifier(this.numberDigits));
    }

    private String combineIntegerAndOutputName(String integerFormatString) {
        if (!this.prefix.isEmpty()) {
            return this.prefix + "_" + integerFormatString;
        }
        return integerFormatString;
    }

    private static String integerFormatSpecifier(int numDigits) {
        return "%0" + Integer.toString(numDigits) + "d";
    }
}

