/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.outputter;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.log.CommonContext;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.io.output.outputter.ChangeOutputter;
import org.anchoranalysis.io.output.outputter.Outputter;

public interface InputOutputContext {
    public Path getModelDirectory();

    public Outputter getOutputter();

    public boolean isDebugEnabled();

    public Logger getLogger();

    public ExecutionTimeRecorder getExecutionTimeRecorder();

    default public CommonContext common() {
        return new CommonContext(this.getLogger(), this.getModelDirectory());
    }

    default public ErrorReporter getErrorReporter() {
        return this.getLogger().errorReporter();
    }

    default public MessageLogger getMessageReporter() {
        return this.getLogger().messageLogger();
    }

    default public InputOutputContext subdirectory(String subdirectoryName, boolean inheritOutputRulesAndRecording) {
        return new ChangeOutputter(this, this.getOutputter().deriveSubdirectory(subdirectoryName, inheritOutputRulesAndRecording));
    }

    default public InputOutputContext maybeSubdirectory(Optional<String> subdirectoryName, boolean inheritOutputRulesAndRecording) {
        return subdirectoryName.map(name -> this.subdirectory((String)name, inheritOutputRulesAndRecording)).orElse(this);
    }

    default public OperationContext operationContext() {
        return new OperationContext(this.getExecutionTimeRecorder(), this.getLogger());
    }
}

