/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.path.prefixer;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.io.output.path.prefixer.PathCreator;

public class DirectoryWithPrefix
implements PathCreator {
    private Path directory;
    private String prefix = "";
    private String delimiter = "";

    public DirectoryWithPrefix(Path directory) {
        this.setDirectory(directory.normalize());
    }

    public void setDirectory(Path directory) {
        this.directory = directory.normalize();
    }

    public Path asPath(boolean includeDelimeter) {
        if (includeDelimeter) {
            return this.getDirectory().resolve(this.prefixWithDelimeter());
        }
        return this.getDirectory().resolve(this.prefix);
    }

    public String prefixWithDelimeter() {
        return this.prefix + this.delimiter;
    }

    @Override
    public Path makePathAbsolute(Optional<String> suffix, Optional<String> extension, String fallbackSuffix) {
        return this.directory.resolve(this.buildFilename(suffix, extension, fallbackSuffix));
    }

    @Override
    public Path makePathRelative(Path fullPath) {
        return this.directory.relativize(fullPath);
    }

    private String buildFilename(Optional<String> suffix, Optional<String> extension, String fallbackSuffix) {
        if (!this.prefix.isEmpty()) {
            return this.prefix + this.concatenate(suffix, extension).orElse("");
        }
        Optional<String> nonEmptySuffix = Optional.of(suffix.orElse(fallbackSuffix));
        return this.concatenate(nonEmptySuffix, extension).get();
    }

    private Optional<String> concatenate(Optional<String> suffix, Optional<String> extension) {
        if (suffix.isPresent() || extension.isPresent()) {
            String contributionFromSuffix = DirectoryWithPrefix.contributionFrom(suffix, this.delimiter);
            String contributionFromExtension = DirectoryWithPrefix.contributionFrom(extension, ".");
            return Optional.of(contributionFromSuffix + contributionFromExtension);
        }
        return Optional.empty();
    }

    private static String contributionFrom(Optional<String> string, String prefix) {
        return string.map(value -> prefix + value).orElse("");
    }

    public DirectoryWithPrefix(Path directory, String prefix, String delimiter) {
        this.directory = directory;
        this.prefix = prefix;
        this.delimiter = delimiter;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

