/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.recorded;

import java.util.Optional;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelAnd;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelNot;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOr;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;

public class OutputEnabledDelta {
    private Optional<MultiLevelOutputEnabled> outputsToEnable = Optional.empty();
    private Optional<MultiLevelOutputEnabled> outputsToDisable = Optional.empty();

    public MultiLevelOutputEnabled applyDelta(MultiLevelOutputEnabled source) {
        MultiLevelOutputEnabled inputAfterEnable = this.maybeEnable(source);
        return this.maybeDisable(inputAfterEnable);
    }

    public void enableAdditionalOutputs(MultiLevelOutputEnabled outputs) {
        this.outputsToEnable = Optional.of(outputs);
    }

    public void disableAdditionalOutputs(MultiLevelOutputEnabled outputs) {
        this.outputsToDisable = Optional.of(outputs);
    }

    private MultiLevelOutputEnabled maybeEnable(MultiLevelOutputEnabled source) {
        if (this.outputsToEnable.isPresent()) {
            return new MultiLevelOr(this.outputsToEnable.get(), source);
        }
        return source;
    }

    private MultiLevelOutputEnabled maybeDisable(MultiLevelOutputEnabled source) {
        if (this.outputsToDisable.isPresent()) {
            return new MultiLevelAnd(new MultiLevelNot(this.outputsToDisable.get()), source);
        }
        return source;
    }
}

