/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.recorded;

import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class RecordedOutputs {
    private Set<String> namesEnabled = new TreeSet<String>();
    private Set<String> namesDisabled = new TreeSet<String>();
    private static final int MAX_OUTPUTS_LISTED = 8;

    public synchronized void add(String outputName, boolean allowed) {
        if (allowed) {
            this.namesEnabled.add(outputName);
        } else {
            this.namesDisabled.add(outputName);
        }
    }

    public int numberEnabled() {
        return this.namesEnabled.size();
    }

    public int numberDisabled() {
        return this.namesDisabled.size();
    }

    public boolean hasAtLeastOneEnabled() {
        return !this.namesEnabled.isEmpty();
    }

    public boolean hasAtLeastOneDisabled() {
        return !this.namesDisabled.isEmpty();
    }

    public boolean hasAtLeastOneMultiplex(boolean enabled) {
        if (enabled) {
            return this.hasAtLeastOneEnabled();
        }
        return this.hasAtLeastOneDisabled();
    }

    public boolean isEmpty() {
        return this.namesEnabled.isEmpty() && this.namesDisabled.isEmpty();
    }

    public String summarizeEnabled() {
        return RecordedOutputs.summarizeNames(this.namesEnabled, 8);
    }

    public String summarizeDisabled() {
        return RecordedOutputs.summarizeNames(this.namesDisabled, 8);
    }

    public String summarizeMultiplex(boolean enabled) {
        if (enabled) {
            return this.summarizeEnabled();
        }
        return this.summarizeDisabled();
    }

    public boolean isRecordedAsEnabled(String outputName) {
        return this.namesEnabled.contains(outputName);
    }

    private static String summarizeNames(Set<String> names, int maxNumber) {
        if (names.size() > maxNumber) {
            return RecordedOutputs.collapseToString(RecordedOutputs.extractElements(names, maxNumber)) + String.format(" plus %d others.", names.size() - maxNumber);
        }
        return RecordedOutputs.collapseToString(names);
    }

    private static <T> Set<T> extractElements(Set<T> set, int numberElements) {
        return set.stream().limit(numberElements).collect(Collectors.toCollection(TreeSet::new));
    }

    private static String collapseToString(Set<String> names) {
        return String.join((CharSequence)", ", names);
    }
}

