/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.xml;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.anchoranalysis.core.serialize.XMLParser;
import org.w3c.dom.Document;

public class XMLWriter {
    public static void writeXMLToFile(Document document, Path path) throws IOException {
        try {
            Transformer transformer = XMLWriter.createTransformer();
            try (FileWriter writer = new FileWriter(path.toFile());){
                StreamResult result = new StreamResult(writer);
                DOMSource source = new DOMSource(document);
                transformer.transform(source, result);
            }
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    private static Transformer createTransformer() throws TransformerConfigurationException {
        Transformer transformer = XMLParser.createTransformerFactory().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }

    private XMLWriter() {
    }
}

