/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.bean;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixer;
import org.anchoranalysis.io.output.bean.rules.OutputEnabledRules;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.outputter.BindFailedException;
import org.anchoranalysis.io.output.outputter.DirectoryCreationParameters;
import org.anchoranalysis.io.output.outputter.OutputWriteContext;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;
import org.anchoranalysis.io.output.recorded.MultiLevelRecordedOutputs;
import org.anchoranalysis.io.output.recorded.RecordedOutputsWithRules;

public class OutputManager
extends AnchorBean<OutputManager> {
    @BeanField
    private PathPrefixer prefixer;
    @BeanField
    private boolean silentlyDeleteExisting = false;
    @BeanField
    private OutputWriteSettings outputWriteSettings = new OutputWriteSettings();
    @BeanField
    @OptionalBean
    private OutputEnabledRules outputsEnabled;

    public MultiLevelOutputEnabled determineEnabledOutputs(RecordedOutputsWithRules recordedOutputs) {
        return recordedOutputs.selectOutputEnabled(Optional.ofNullable(this.outputsEnabled));
    }

    public OutputWriteContext createContextForWriting(Optional<ImageFileFormat> suggestedFormatToWrite, ExecutionTimeRecorder executionTimeRecorder) {
        return new OutputWriteContext(this.getOutputWriteSettings(), suggestedFormatToWrite, executionTimeRecorder);
    }

    public OutputterChecked createExperimentOutputter(Optional<String> experimentIdentifier, MultiLevelOutputEnabled outputsEnabled, Optional<MultiLevelRecordedOutputs> recordedOutputs, OutputWriteContext writeContext, PathPrefixerContext prefixerContext, Optional<Consumer<Path>> callUponDirectoryCreation, Optional<Logger> logger) throws BindFailedException {
        try {
            DirectoryWithPrefix prefix = this.prefixer.rootDirectoryPrefix(experimentIdentifier, prefixerContext);
            return OutputterChecked.createWithPrefix(prefix, outputsEnabled, writeContext, recordedOutputs, new DirectoryCreationParameters(this.silentlyDeleteExisting, callUponDirectoryCreation), logger);
        }
        catch (PathPrefixerException e) {
            throw new BindFailedException((Throwable)((Object)e));
        }
    }

    @Generated
    public PathPrefixer getPrefixer() {
        return this.prefixer;
    }

    @Generated
    public void setPrefixer(PathPrefixer prefixer) {
        this.prefixer = prefixer;
    }

    @Generated
    public boolean isSilentlyDeleteExisting() {
        return this.silentlyDeleteExisting;
    }

    @Generated
    public void setSilentlyDeleteExisting(boolean silentlyDeleteExisting) {
        this.silentlyDeleteExisting = silentlyDeleteExisting;
    }

    @Generated
    public OutputWriteSettings getOutputWriteSettings() {
        return this.outputWriteSettings;
    }

    @Generated
    public void setOutputWriteSettings(OutputWriteSettings outputWriteSettings) {
        this.outputWriteSettings = outputWriteSettings;
    }

    @Generated
    public OutputEnabledRules getOutputsEnabled() {
        return this.outputsEnabled;
    }

    @Generated
    public void setOutputsEnabled(OutputEnabledRules outputsEnabled) {
        this.outputsEnabled = outputsEnabled;
    }
}

