/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.recorded;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.io.output.bean.rules.OutputEnabledRules;
import org.anchoranalysis.io.output.bean.rules.Permissive;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.recorded.MultiLevelRecordedOutputs;
import org.anchoranalysis.io.output.recorded.OutputEnabledDelta;

public class RecordedOutputsWithRules {
    private final Optional<MultiLevelRecordedOutputs> recordedOutputs;
    private final Optional<MultiLevelOutputEnabled> defaultRules;
    private final Optional<OutputEnabledDelta> delta;

    public RecordedOutputsWithRules() {
        this.recordedOutputs = Optional.empty();
        this.defaultRules = Optional.empty();
        this.delta = Optional.empty();
    }

    public RecordedOutputsWithRules(MultiLevelRecordedOutputs recordedOutputs, MultiLevelOutputEnabled defaultRules, OutputEnabledDelta delta) {
        this.recordedOutputs = Optional.of(recordedOutputs);
        this.defaultRules = Optional.of(defaultRules);
        this.delta = Optional.of(delta);
    }

    public MultiLevelOutputEnabled selectOutputEnabled(Optional<OutputEnabledRules> rulesHigherPrecedence) {
        if (rulesHigherPrecedence.isPresent()) {
            return this.additionalCombinedWith(rulesHigherPrecedence.get().create(this.defaultRules));
        }
        if (this.defaultRules.isPresent()) {
            return this.additionalCombinedWith(this.defaultRules.get());
        }
        return Permissive.INSTANCE;
    }

    private MultiLevelOutputEnabled additionalCombinedWith(MultiLevelOutputEnabled other) {
        if (this.delta.isPresent()) {
            return this.delta.get().applyDelta(other);
        }
        return other;
    }

    @Generated
    public Optional<MultiLevelRecordedOutputs> getRecordedOutputs() {
        return this.recordedOutputs;
    }
}

