/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.output.recorded;

import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.enabled.single.SingleLevelOutputEnabled;
import org.anchoranalysis.io.output.recorded.MultiLevelRecordedOutputs;
import org.anchoranalysis.io.output.recorded.RecordOutputNamesForWriter;
import org.anchoranalysis.io.output.recorded.RecordedOutputs;
import org.anchoranalysis.io.output.writer.AlwaysAllowed;
import org.anchoranalysis.io.output.writer.CheckIfAllowed;
import org.anchoranalysis.io.output.writer.ElementOutputter;
import org.anchoranalysis.io.output.writer.Writer;
import org.anchoranalysis.io.output.writer.WriterExecuteBeforeEveryOperation;

public class RecordingWriters {
    private final Writer permissiveNoRecording;
    private final Writer permissiveRecording;
    private final Writer selectiveRecording;
    private final Optional<MultiLevelRecordedOutputs> recordedOutputs;
    private final MultiLevelOutputEnabled outputEnabled;

    public RecordingWriters(ElementOutputter outputter, Optional<WriterExecuteBeforeEveryOperation> preop, Optional<MultiLevelRecordedOutputs> recordedOutputs) {
        this.recordedOutputs = recordedOutputs;
        this.outputEnabled = outputter.getOutputsEnabled();
        this.permissiveNoRecording = new AlwaysAllowed(outputter, preop);
        this.permissiveRecording = this.recordFirstLevel(this.permissiveNoRecording);
        this.selectiveRecording = this.recordFirstLevel(new CheckIfAllowed(outputter.getOutputsEnabled(), preop, this.permissiveRecording));
    }

    public Writer multiplex(boolean selectSelective) {
        if (selectSelective) {
            return this.selectiveRecording;
        }
        return this.permissiveRecording;
    }

    public Writer secondLevel(String outputNameFirstLevel) {
        SingleLevelOutputEnabled outputEnabledSecondLevel = this.outputEnabled.second(outputNameFirstLevel);
        CheckIfAllowed secondLevelWriter = new CheckIfAllowed(outputEnabledSecondLevel, Optional.empty(), this.permissiveNoRecording);
        return this.recordSecondLevel(secondLevelWriter, outputNameFirstLevel);
    }

    public Writer permissive() {
        return this.permissiveRecording;
    }

    public Writer selective() {
        return this.selectiveRecording;
    }

    private Writer recordFirstLevel(Writer writer) {
        return this.recordWriter(writer, MultiLevelRecordedOutputs::first);
    }

    private Writer recordSecondLevel(Writer writer, String outputNameFirstLevel) {
        return this.recordWriter(writer, multiLevel -> multiLevel.second(outputNameFirstLevel));
    }

    private Writer recordWriter(Writer writer, Function<MultiLevelRecordedOutputs, RecordedOutputs> extractRecordedOutputs) {
        if (this.recordedOutputs.isPresent()) {
            return new RecordOutputNamesForWriter(writer, extractRecordedOutputs.apply(this.recordedOutputs.get()), false);
        }
        return writer;
    }

    @Generated
    public Optional<MultiLevelRecordedOutputs> recordedOutputs() {
        return this.recordedOutputs;
    }
}

