/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.config;

import java.nio.file.Path;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.launcher.config.HelpConfig;
import org.anchoranalysis.launcher.config.PathCurrentJarHelper;
import org.anchoranalysis.launcher.config.PathDeriver;
import org.anchoranalysis.launcher.executor.ExperimentExecutor;
import org.anchoranalysis.launcher.executor.ExperimentExecutorFactory;
import org.anchoranalysis.launcher.resources.Resources;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public abstract class LauncherConfig {
    public abstract Resources resources();

    public abstract HelpConfig help();

    public abstract boolean newlinesBeforeError();

    public abstract ExecutionArguments createArguments(CommandLine var1) throws ExperimentExecutionException;

    public abstract void addAdditionalOptions(Options var1);

    public ExperimentExecutor createExperimentExecutor(CommandLine line) throws ExperimentExecutionException {
        Path pathCurrentJARDir = PathCurrentJarHelper.pathCurrentJAR(this.classInCurrentJar());
        Path pathDefaultExperiment = this.pathDefaultExperiment(pathCurrentJARDir);
        return ExperimentExecutorFactory.create(line, pathDefaultExperiment, pathDefaultExperiment.getParent());
    }

    public abstract void customizeExperimentExecutor(ExperimentExecutor var1, CommandLine var2) throws ExperimentExecutionException;

    protected abstract String pathRelativeProperties();

    protected abstract Class<?> classInCurrentJar();

    private Path pathDefaultExperiment(Path pathCurrentJARDir) throws ExperimentExecutionException {
        return PathDeriver.pathDefaultExperiment(pathCurrentJARDir, this.pathRelativeProperties());
    }
}

