/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;

class PathCurrentJarHelper {
    public static Path pathCurrentJAR(Class<?> classLauncher) {
        try {
            URI pathURI = classLauncher.getProtectionDomain().getCodeSource().getLocation().toURI();
            return PathCurrentJarHelper.pathFromUri(pathURI);
        }
        catch (URISyntaxException e) {
            throw new AnchorFriendlyRuntimeException("An invalid URI was used in establishing the path to the current JAR", (Throwable)e);
        }
    }

    private static Path pathFromUri(URI uri) {
        Path path = Paths.get(uri);
        if (path.toFile().isDirectory()) {
            return path;
        }
        return path.getParent();
    }

    @Generated
    private PathCurrentJarHelper() {
    }
}

