/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.experiment;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.experiment.UseDefaultExperiment;
import org.anchoranalysis.launcher.executor.selectparam.experiment.UseExperimentPassedAsPath;
import org.apache.commons.cli.CommandLine;

public class ExperimentFactory {
    public static SelectParam<Path> defaultExperimentOrCustom(CommandLine line, Path defaultExperiment) throws ExperimentExecutionException {
        if (line.getArgs().length == 1) {
            return new UseExperimentPassedAsPath(ExperimentFactory.extractPath(line));
        }
        return new UseDefaultExperiment(defaultExperiment);
    }

    private static Path extractPath(CommandLine line) throws ExperimentExecutionException {
        String str = line.getArgs()[0];
        if (str.contains("*")) {
            throw new ExperimentExecutionException(String.format("Error: Cannot accept a wildcard in path to experiment BeanXML: %s", str));
        }
        try {
            return Paths.get(str, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new ExperimentExecutionException(String.format("Error: The argument \"%s\" should be a path to experiment BeanXML, but is invalid.", str));
        }
    }

    @Generated
    private ExperimentFactory() {
    }
}

