/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.path;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.launcher.CommandLineException;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.path.UseAsCustomManager;
import org.anchoranalysis.launcher.executor.selectparam.path.UseDirectoryForManager;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.ArgumentConverter;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.InvalidPathArgumentException;

public class OutputFactory {
    public static SelectParam<Optional<Path>> pathOrDirectory(String[] arguments, boolean writeIntoRoot) {
        if (arguments.length > 1) {
            throw new CommandLineException(String.format("More than one argument was passed to -%s. Only one is allowed!", "o"));
        }
        String pathArgument = arguments[0];
        try {
            Path path = ArgumentConverter.pathFromArgument(pathArgument);
            File file = path.toFile();
            if (file.isDirectory()) {
                if (writeIntoRoot) {
                    throw new CommandLineException(String.format("The output-directory already exists. This is not permitted when option -%s is employed.", "oo"));
                }
                return OutputFactory.usePathAsDirectoryForManager(path, false, true);
            }
            if (file.exists()) {
                if (writeIntoRoot) {
                    throw new CommandLineException(String.format("No output-directory was selected, as is required with option -%s", "oo"));
                }
                return OutputFactory.usePathAsBeanXML(path);
            }
            return OutputFactory.pathNotExisting(pathArgument, path, file, writeIntoRoot);
        }
        catch (InvalidPathArgumentException e) {
            throw e.toCommandLineException();
        }
    }

    private static SelectParam<Optional<Path>> pathNotExisting(String pathArgument, Path path, File file, boolean writeIntoRoot) {
        if (OutputFactory.looksLikeDirectoryPath(pathArgument) || writeIntoRoot) {
            if (!writeIntoRoot) {
                file.mkdirs();
            }
            return OutputFactory.usePathAsDirectoryForManager(path, false, !writeIntoRoot);
        }
        throw new CommandLineException(String.format("The argument '%s' for -%s or -%s:%n  - is neither a path to an existing file (BeanXML for an output-manager).%n  - nor looks like a directory (into which outputting occurs).%n%nSee %s%n", pathArgument, "o", "output", "https://www.anchoranalysis.org/user_guide_command_line.html#output-options"));
    }

    private static SelectParam<Optional<Path>> usePathAsDirectoryForManager(Path path, boolean input, boolean checkDirectoryExists) {
        return new UseDirectoryForManager(path, input, checkDirectoryExists);
    }

    private static SelectParam<Optional<Path>> usePathAsBeanXML(Path path) {
        return new UseAsCustomManager(path);
    }

    private static boolean looksLikeDirectoryPath(String argument) {
        return argument.endsWith("/") || argument.endsWith("\\");
    }

    @Generated
    private OutputFactory() {
    }
}

