/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.path;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.format.NonImageFileFormat;
import org.anchoranalysis.launcher.CommandLineException;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.path.UpdateTaskName;
import org.anchoranalysis.launcher.executor.selectparam.path.UseAsCustomManager;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.ArgumentConverter;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.InvalidPathArgumentException;

public class TaskFactory {
    public static SelectParam<Optional<Path>> pathOrTaskName(String[] args, Path tasksDirectory) {
        if (args == null) {
            throw new CommandLineException("An argument (a task-name) must be specified after -t");
        }
        if (args.length != 1) {
            throw new CommandLineException("Only one instance of the -t option is permitted.");
        }
        String taskArg = args[0];
        if (TaskFactory.isTaskName(taskArg)) {
            Path path = TaskFactory.pathForTaskCheckExists(taskArg, tasksDirectory);
            return new UpdateTaskName<Optional<Path>>(new UseAsCustomManager(path), taskArg);
        }
        try {
            return new UseAsCustomManager(ArgumentConverter.pathFromArgument(taskArg));
        }
        catch (InvalidPathArgumentException e) {
            throw new CommandLineException(e.toString());
        }
    }

    private static Path pathForTaskCheckExists(String taskName, Path tasksDirectory) {
        Path path = TaskFactory.pathForTaskName(taskName, tasksDirectory);
        if (path.toFile().exists()) {
            return path;
        }
        throw new CommandLineException(String.format("The task '%s' is not known.", taskName));
    }

    private static Path pathForTaskName(String filenameWithoutExtension, Path tasksDirectory) {
        return NonImageFileFormat.XML.buildPath(tasksDirectory, filenameWithoutExtension);
    }

    private static boolean isTaskName(String arg) {
        return arg.matches("^[a-zA-Z0-9_\\-\\/]+$");
    }

    @Generated
    private TaskFactory() {
    }
}

