/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.path;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.InvalidPathArgumentException;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.PrettyPathConverter;

class UseListFilesForManager
implements SelectParam<Optional<Path>> {
    private final List<Path> paths;

    public UseListFilesForManager(List<Path> paths) throws InvalidPathArgumentException {
        this.paths = paths;
        this.checkNoDirectories(paths);
    }

    @Override
    public Optional<Path> select(ExecutionArguments executionArguments) {
        executionArguments.input().getContextParameters().assignPaths(this.paths);
        return Optional.empty();
    }

    @Override
    public String describe() throws ExperimentExecutionException {
        return String.join((CharSequence)", ", FunctionalList.mapToList(this.paths, PrettyPathConverter::prettyPath));
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    private void checkNoDirectories(List<Path> paths) throws InvalidPathArgumentException {
        for (Path path : paths) {
            File file = path.toFile();
            if (!file.exists()) {
                throw new InvalidPathArgumentException(String.format("No input file exists at path: %s", path));
            }
            if (!file.isDirectory()) continue;
            throw new InvalidPathArgumentException(String.format("Path is a directory not a file for input!%n%s", path));
        }
    }
}

