/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.path.convert;

import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;

public class PrettyPathConverter {
    private static final int MAX_DOUBLE_DOTS_CNT = 3;

    public static String prettyPath(String path) {
        return PrettyPathConverter.prettyPath(Paths.get(path, new String[0]));
    }

    public static String prettyPath(Path path) {
        Path workingDir = PrettyPathConverter.completelyNormalize(Paths.get("", new String[0]));
        return PrettyPathConverter.prettyPath(PrettyPathConverter.completelyNormalize(path), PrettyPathConverter.completelyNormalize(workingDir));
    }

    static String prettyPath(Path path, Path workingDir) {
        path = path.toAbsolutePath().normalize();
        if ((workingDir = workingDir.toAbsolutePath().normalize()).equals(path)) {
            return ".";
        }
        if (workingDir.getRoot().equals(path.getRoot())) {
            Path relativePath = workingDir.relativize(path).normalize();
            if (PrettyPathConverter.countDoubleDotsInRelativePath(relativePath) > 3) {
                return path.toString();
            }
            return relativePath.toString();
        }
        return path.toAbsolutePath().normalize().toString();
    }

    static Path completelyNormalize(Path path) {
        return path.toAbsolutePath().normalize();
    }

    private static int countDoubleDotsInRelativePath(Path path) {
        int count = 0;
        for (Path pathComponent : path) {
            if (!pathComponent.getFileName().toString().equals("..")) continue;
            ++count;
        }
        return count;
    }

    @Generated
    private PrettyPathConverter() {
    }
}

