/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.run;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.launcher.config.LauncherConfig;
import org.anchoranalysis.launcher.executor.ExperimentExecutor;
import org.anchoranalysis.launcher.options.CommandLineOptions;
import org.anchoranalysis.launcher.run.ErrorPrinter;
import org.anchoranalysis.launcher.run.MessagePrinter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ParseArgumentsAndRunExperiment {
    private final Logger logger;

    public void parseAndRun(String[] arguments, LauncherConfig config) {
        Options options = this.createOptions(config);
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, arguments);
            MessagePrinter messagePrinter = new MessagePrinter(config.resources());
            if (messagePrinter.maybePrintHelp(line, options, config.help())) {
                return;
            }
            if (messagePrinter.maybePrintVersion(line)) {
                return;
            }
            if (line.getArgs().length > 1) {
                ErrorPrinter.printTooManyArguments();
                return;
            }
            this.processExperimentShowErrors(line, config, messagePrinter);
        }
        catch (ParseException e) {
            this.logger.messageLogger().logFormatted("Parsing of command-line arguments failed.  Reason: %s%n", new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            this.logger.errorReporter().recordError(ParseArgumentsAndRunExperiment.class, (Throwable)e);
            this.logger.messageLogger().logFormatted("An I/O error occurred.  Reason: %s%n", new Object[]{e.getMessage()});
        }
        catch (AnchorFriendlyRuntimeException e) {
            this.logger.messageLogger().logFormatted(e.friendlyMessageHierarchy(), new Object[0]);
        }
    }

    private void processExperimentShowErrors(CommandLine line, LauncherConfig config, MessagePrinter messagePrinter) {
        block3: {
            try {
                this.processExperiment(line, this.logger, config, messagePrinter);
            }
            catch (ExperimentExecutionException e) {
                if (config.newlinesBeforeError()) {
                    this.logger.messageLogger().logFormatted("%n", new Object[0]);
                }
                this.logger.messageLogger().log(e.friendlyMessageHierarchy());
                if (!line.hasOption("l")) break block3;
                Path errorLogPath = Paths.get(line.getOptionValue("l"), new String[0]);
                this.logger.messageLogger().logFormatted("Logging error in \"%s\"%n", new Object[]{errorLogPath.toAbsolutePath()});
                ErrorPrinter.printErrorLog(e, errorLogPath);
            }
        }
    }

    private void processExperiment(CommandLine line, Logger logger, LauncherConfig config, MessagePrinter messagePrinter) throws ExperimentExecutionException {
        ExperimentExecutor executor = config.createExperimentExecutor(line);
        if (messagePrinter.maybeShowTasks(line, executor.taskDirectory())) {
            return;
        }
        config.customizeExperimentExecutor(executor, line);
        executor.executeExperiment(config.createArguments(line), line.hasOption("sa"), logger);
    }

    private Options createOptions(LauncherConfig config) {
        Options options = new Options();
        CommandLineOptions.addBasicOptions(options);
        config.addAdditionalOptions(options);
        return options;
    }

    @Generated
    public ParseArgumentsAndRunExperiment(Logger logger) {
        this.logger = logger;
    }
}

