/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.run.tasks;

import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;

class DescribeTaskNames {
    public static void printTaskNames(PrintStream printTo, Multimap<String, String> tasks) {
        printTo.printf("There are %d predefined tasks:%n", tasks.size());
        printTo.println();
        HashSet<String> rootTasks = new HashSet<String>(tasks.get((Object)""));
        SortedSet<String> rootTasksExcluding = DescribeTaskNames.removeTasksWithSubdirectory(rootTasks, tasks);
        printTo.println(DescribeTaskNames.describeDirectoryRoot(rootTasksExcluding));
        if (tasks.keySet().size() > 1) {
            printTo.println();
        }
        for (String key : tasks.keySet()) {
            if (key.isEmpty()) continue;
            printTo.println(DescribeTaskNames.describeSubdirectory(key, tasks.get((Object)key), rootTasks.contains(key)));
        }
    }

    private static SortedSet<String> removeTasksWithSubdirectory(Set<String> rootTasks, Multimap<String, String> tasksIndexed) {
        return rootTasks.stream().filter(task -> !tasksIndexed.containsKey(task)).collect(Collectors.toCollection(TreeSet::new));
    }

    private static String describeDirectoryRoot(Collection<String> filenames) {
        return String.join((CharSequence)", ", filenames);
    }

    private static String describeSubdirectory(String directory, Collection<String> filenames, boolean taskInRoot) {
        StringBuilder builder = new StringBuilder();
        if (taskInRoot) {
            builder.append(directory);
            builder.append(" -or- ");
        }
        builder.append(String.format("%s/{%s}", directory, String.join((CharSequence)" | ", filenames)));
        return builder.toString();
    }

    @Generated
    private DescribeTaskNames() {
    }
}

