/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.run.tasks;

import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.launcher.resources.Resources;
import org.anchoranalysis.launcher.run.tasks.DescribeTaskNames;
import org.anchoranalysis.launcher.run.tasks.FindTasks;
import org.anchoranalysis.launcher.run.tasks.TasksIndexer;

public class PredefinedTasks {
    public static void printTasksToConsole(Path tasksDirectory, Resources resources, PrintStream printTo) {
        try {
            Multimap<String, String> tasksIndexed = TasksIndexer.indexBySubdirectory(FindTasks.taskNames(tasksDirectory));
            if (!tasksIndexed.isEmpty()) {
                DescribeTaskNames.printTaskNames(printTo, tasksIndexed);
                printTo.println();
                PredefinedTasks.printHelpfulTextAdvice(printTo, resources);
            } else {
                printTo.printf("No predefined tasks exist (in %s%n).", tasksDirectory);
            }
        }
        catch (InputReadFailedException e) {
            printTo.printf("An error occurred searching the file-system for predefined tasks: %s", e.toString());
        }
    }

    private static void printHelpfulTextAdvice(PrintStream printTo, Resources resources) {
        printTo.printf("Run a predefined task with the -%s <taskName> command line option.%n", "t");
        printTo.println("e.g. anchor -t resize");
        printTo.println("e.g. anchor -t montage/reorder");
        printTo.println("e.g. anchor -t segment/text");
        printTo.println();
        printTo.println("When no task is explicitly specified, the default task is used: summmarize/paths");
        printTo.println(resources.tasksFooter());
    }

    @Generated
    private PredefinedTasks() {
    }
}

