/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher;

import java.util.Optional;
import org.anchoranalysis.core.functional.checked.CheckedConsumer;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.experiment.arguments.TaskArguments;
import org.anchoranalysis.launcher.config.HelpConfig;
import org.anchoranalysis.launcher.config.LauncherConfig;
import org.anchoranalysis.launcher.executor.ExperimentExecutor;
import org.anchoranalysis.launcher.executor.selectparam.SelectParamFactory;
import org.anchoranalysis.launcher.options.CommandLineExtracter;
import org.anchoranalysis.launcher.options.CommandLineOptions;
import org.anchoranalysis.launcher.options.process.AddInputOptions;
import org.anchoranalysis.launcher.options.process.AddOutputOptions;
import org.anchoranalysis.launcher.resources.Resources;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

class LauncherConfigCommandLine
extends LauncherConfig {
    private static final String RESOURCE_VERSION_FOOTER = "org/anchoranalysis/launcher/versionFooterDisplayMessage.txt";
    private static final String RESOURCE_MAVEN_PROPERTIES = "META-INF/maven/org.anchoranalysis.anchor/anchor-launcher/pom.properties";
    private static final String RESOURCE_USAGE_HEADER = "org/anchoranalysis/launcher/usageHeaderDisplayMessage.txt";
    private static final String RESOURCE_USAGE_FOOTER = "org/anchoranalysis/launcher/usageFooterDisplayMessage.txt";
    private static final String RESOURCE_TASKS_FOOTER = "org/anchoranalysis/launcher/tasksFooterDisplayMessage.txt";
    private static final String DEFAULT_FIRST_ARGUMENT = "experimentFile.xml";
    private static final String COMMAND_NAME = "anchor";
    private static final String PATH_RELATIVE_PROPERTIES = "anchor.properties";
    private static final String BEHAVIOUR_MESSAGE_FOR_DEFAULT_EXPERIMENT = "Searching recursively for image files. CTRL+C cancels";

    LauncherConfigCommandLine() {
    }

    @Override
    public void addAdditionalOptions(Options options) {
        CommandLineOptions.addAdditionalOptions(options);
    }

    @Override
    public Resources resources() {
        return new Resources(this.getClass().getClassLoader(), RESOURCE_VERSION_FOOTER, RESOURCE_MAVEN_PROPERTIES, RESOURCE_USAGE_HEADER, RESOURCE_USAGE_FOOTER, Optional.of(RESOURCE_TASKS_FOOTER));
    }

    @Override
    public ExecutionArguments createArguments(CommandLine line) throws ExperimentExecutionException {
        ExecutionArguments arguments = new ExecutionArguments();
        CommandLineExtracter extract = new CommandLineExtracter(line);
        extract.ifPresentSingle("d", (CheckedConsumer<String, ExperimentExecutionException>)((CheckedConsumer)arg_0 -> ((ExecutionArguments)arguments).activateDebugMode(arg_0)));
        extract.ifPresentSingle("tp", (CheckedConsumer<String, ExperimentExecutionException>)((CheckedConsumer)arg_0 -> ((TaskArguments)arguments.task()).assignMaxNumberProcessors(arg_0)));
        extract.ifPresentSingle("ps", (CheckedConsumer<String, ExperimentExecutionException>)((CheckedConsumer)arg_0 -> ((TaskArguments)arguments.task()).assignSize(arg_0)));
        extract.ifPresentSingle("pg", (CheckedConsumer<String, ExperimentExecutionException>)((CheckedConsumer)arg_0 -> ((TaskArguments)arguments.task()).assignGroup(arg_0)));
        AddInputOptions.addFrom(extract, arguments.input());
        AddOutputOptions.addFrom(extract, arguments.output());
        return arguments;
    }

    @Override
    protected Class<?> classInCurrentJar() {
        return LauncherConfigCommandLine.class;
    }

    @Override
    public boolean newlinesBeforeError() {
        return false;
    }

    @Override
    public HelpConfig help() {
        return new HelpConfig(COMMAND_NAME, DEFAULT_FIRST_ARGUMENT);
    }

    @Override
    protected String pathRelativeProperties() {
        return PATH_RELATIVE_PROPERTIES;
    }

    @Override
    public void customizeExperimentExecutor(ExperimentExecutor executor, CommandLine line) throws ExperimentExecutionException {
        executor.setInput(SelectParamFactory.inputSelectParam(line));
        executor.setOutput(SelectParamFactory.outputSelectParam(line));
        executor.setTask(SelectParamFactory.pathOrTaskNameOrDefault(line, "t", executor.taskDirectory()));
        executor.setDefaultBehaviourString(Optional.of(BEHAVIOUR_MESSAGE_FOR_DEFAULT_EXPERIMENT));
        LauncherConfigCommandLine.maybeShowInDesktop(executor, line);
    }

    private static void maybeShowInDesktop(ExperimentExecutor executor, CommandLine line) {
        boolean showInDesktop = !line.hasOption("oc");
        executor.setOpenInDesktop(showInDesktop);
    }
}

