/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import lombok.Generated;
import org.anchoranalysis.experiment.ExperimentExecutionException;

class PathDeriver {
    private static final String PROPERTY_PATH_RELATIVE_DEFAULT_EXPERIMENT = "default.config.path.relative";

    public static Path pathDefaultExperiment(Path pathCurrentJARDir, String pathRelativeProperties) throws ExperimentExecutionException {
        String relativePathDefaultExperiment = PathDeriver.relativePathDefaultExperiment(PathDeriver.propertyPath(pathCurrentJARDir, pathRelativeProperties));
        return pathCurrentJARDir.resolve(relativePathDefaultExperiment);
    }

    private static String relativePathDefaultExperiment(Path propertyPath) throws ExperimentExecutionException {
        Properties props = new Properties();
        try (FileInputStream stream = new FileInputStream(propertyPath.toFile());){
            props.load(stream);
        }
        catch (IOException e) {
            throw new ExperimentExecutionException(String.format("An error occurred loading properties from the properties file at %s)", propertyPath), (Throwable)e);
        }
        if (!props.containsKey(PROPERTY_PATH_RELATIVE_DEFAULT_EXPERIMENT)) {
            throw new ExperimentExecutionException(String.format("Properties file is missing key: %s", PROPERTY_PATH_RELATIVE_DEFAULT_EXPERIMENT));
        }
        return props.getProperty(PROPERTY_PATH_RELATIVE_DEFAULT_EXPERIMENT);
    }

    private static Path propertyPath(Path currentJARDir, String pathRelativeProperties) throws ExperimentExecutionException {
        Path pathProperties = currentJARDir.resolve(pathRelativeProperties);
        if (!pathProperties.toFile().exists()) {
            throw new ExperimentExecutionException(String.format("Cannot find properties file at: %s", pathProperties));
        }
        return pathProperties;
    }

    @Generated
    private PathDeriver() {
    }
}

