/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor;

import com.google.common.base.Preconditions;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.core.log.error.ErrorReporter;

class DesktopPathOpener {
    public static void openPathInDesktop(Path path, ErrorReporter errorReporter) {
        Preconditions.checkArgument((boolean)path.toFile().isDirectory());
        try {
            if (path.toFile().exists()) {
                Desktop desktop = Desktop.getDesktop();
                desktop.open(path.toFile());
            }
        }
        catch (UnsupportedOperationException desktop) {
        }
        catch (IOException e) {
            errorReporter.recordError(DesktopPathOpener.class, "Failed to open output-directory in desktop, as requested:", (Throwable)e);
        }
    }

    @Generated
    private DesktopPathOpener() {
    }
}

