/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.experiment.bean.Experiment;
import org.anchoranalysis.launcher.executor.BeanReader;
import org.anchoranalysis.launcher.executor.DesktopPathOpener;
import org.anchoranalysis.launcher.executor.ExperimentExecutorAfter;
import org.anchoranalysis.launcher.executor.SelectPathDescriber;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.SelectParamFactory;

public class ExperimentExecutor {
    private static final String TASKS_SUBDIRECTORY_NAME = "tasks";
    private final SelectParam<Path> experiment;
    private final Path configDirectory;
    private SelectParam<Optional<Path>> input = SelectParamFactory.useDefault();
    private SelectParam<Optional<Path>> output = SelectParamFactory.useDefault();
    private SelectParam<Optional<Path>> task = SelectParamFactory.useDefault();
    private boolean openInDesktop = false;
    private Optional<String> defaultBehaviourString = Optional.empty();

    public void executeExperiment(ExecutionArguments executionArguments, boolean alwaysShowExperimentArguments, Logger logger) throws ExperimentExecutionException {
        if (this.openInDesktop) {
            Consumer<Path> desktopOpener = path -> DesktopPathOpener.openPathInDesktop(path, logger.errorReporter());
            executionArguments.input().assignCallUponDirectoryCreation(desktopOpener);
        }
        ExperimentExecutorAfter delegate = new ExperimentExecutorAfter(this.configDirectory);
        if (this.defaultBehaviourString.isPresent() && this.areAllDefault()) {
            logger.messageLogger().logFormatted("%s.%nLearn how to select inputs, outputs and tasks with 'anchor -%s'.%n", new Object[]{this.defaultBehaviourString.get(), "h"});
        }
        Experiment experimentLoaded = this.loadExperimentFromPath(executionArguments);
        if (alwaysShowExperimentArguments || experimentLoaded.useDetailedLogging()) {
            logger.messageLogger().log(this.describe());
        }
        this.setupModelDirectory(this.configDirectory, executionArguments);
        delegate.executeExperiment(experimentLoaded, executionArguments, this.getInput().select(executionArguments), this.getOutput().select(executionArguments), this.getTask().select(executionArguments));
    }

    public Path taskDirectory() {
        return this.configDirectory.resolve(TASKS_SUBDIRECTORY_NAME);
    }

    private void setupModelDirectory(Path pathExecutionDirectory, ExecutionArguments execArgs) {
        execArgs.input().assignModelDirectory(pathExecutionDirectory.getParent().resolve("models").normalize().toAbsolutePath());
    }

    private String describe() throws ExperimentExecutionException {
        return String.format("%s%s%n", this.describeExperiment(), SelectPathDescriber.describe(this.input, this.output, this.task));
    }

    private String describeExperiment() throws ExperimentExecutionException {
        return String.format("Executing %s", this.experiment.describe());
    }

    private boolean areAllDefault() {
        return this.experiment.isDefault() && this.input.isDefault() && this.output.isDefault() && this.task.isDefault();
    }

    private Experiment loadExperimentFromPath(ExecutionArguments execArgs) throws ExperimentExecutionException {
        return BeanReader.readExperimentFromXML(this.experiment.select(execArgs));
    }

    @Generated
    ExperimentExecutor(SelectParam<Path> experiment, Path configDirectory) {
        this.experiment = experiment;
        this.configDirectory = configDirectory;
    }

    @Generated
    public SelectParam<Optional<Path>> getInput() {
        return this.input;
    }

    @Generated
    public void setInput(SelectParam<Optional<Path>> input) {
        this.input = input;
    }

    @Generated
    public SelectParam<Optional<Path>> getOutput() {
        return this.output;
    }

    @Generated
    public void setOutput(SelectParam<Optional<Path>> output) {
        this.output = output;
    }

    @Generated
    public SelectParam<Optional<Path>> getTask() {
        return this.task;
    }

    @Generated
    public void setTask(SelectParam<Optional<Path>> task) {
        this.task = task;
    }

    @Generated
    public boolean isOpenInDesktop() {
        return this.openInDesktop;
    }

    @Generated
    public void setOpenInDesktop(boolean openInDesktop) {
        this.openInDesktop = openInDesktop;
    }

    @Generated
    public void setDefaultBehaviourString(Optional<String> defaultBehaviourString) {
        this.defaultBehaviourString = defaultBehaviourString;
    }
}

