/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.executor.selectparam.path;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.launcher.CommandLineException;
import org.anchoranalysis.launcher.executor.selectparam.SelectParam;
import org.anchoranalysis.launcher.executor.selectparam.path.convert.PrettyPathConverter;

class UseDirectoryForManager
implements SelectParam<Optional<Path>> {
    private final boolean input;
    private final Path directory;

    public UseDirectoryForManager(Path directory, boolean input, boolean checkDirectoryExists) {
        this.input = input;
        this.directory = directory;
        if (checkDirectoryExists && !directory.toFile().isDirectory()) {
            throw new CommandLineException(String.format("The path %s to UseDirectoryForManager must be a directory", directory));
        }
    }

    @Override
    public Optional<Path> select(ExecutionArguments executionArguments) {
        if (this.input) {
            executionArguments.input().getContextParameters().assignInputDirectory(Optional.of(this.directory));
        } else {
            executionArguments.output().getPrefixer().assignOutputDirectory(this.directory);
        }
        return Optional.empty();
    }

    @Override
    public String describe() throws ExperimentExecutionException {
        return PrettyPathConverter.prettyPath(this.directory);
    }

    @Override
    public boolean isDefault() {
        return false;
    }
}

