/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.options;

import lombok.Generated;
import org.anchoranalysis.launcher.options.CustomArgumentOptions;
import org.apache.commons.cli.Options;

public class CommandLineOptions {
    public static final String SHORT_OPTION_INPUT = "i";
    public static final String SHORT_OPTION_INPUT_COPY_NON_INPUTS = "ic";
    public static final String SHORT_OPTION_INPUT_SUBSET_IDENTIFIER = "ii";
    public static final String SHORT_OPTION_INPUT_RELATIVE_PATH = "ip";
    public static final String SHORT_OPTION_INPUT_SHUFFLE = "is";
    public static final String SHORT_OPTION_INPUT_LIMIT = "il";
    public static final String SHORT_OPTION_INPUT_RANDOM_SAMPLE = "ir";
    public static final String SHORT_OPTION_TASK = "t";
    public static final String SHORT_OPTION_TASK_NUMBER_PROCESSORS = "tp";
    public static final String SHORT_OPTION_TASK_SIZE = "ps";
    public static final String SHORT_OPTION_GROUP = "pg";
    public static final String SHORT_OPTION_OUTPUT = "o";
    public static final String SHORT_OPTION_OUTPUT_ENABLE_ADDITIONAL = "oe";
    public static final String SHORT_OPTION_OUTPUT_DISABLE_ADDITIONAL = "od";
    public static final String SHORT_OPTION_OUTPUT_ENABLE_ALL = "oa";
    public static final String SHORT_OPTION_OUTPUT_CONSOLE_ONLY = "oc";
    public static final String SHORT_OPTION_OUTPUT_IMAGE_FILE_FORMAT = "of";
    public static final String SHORT_OPTION_OUTPUT_INCREMENTING_NUMBER = "on";
    public static final String SHORT_OPTION_OUTPUT_SUPPRESS_DIRECTORIES = "os";
    public static final String SHORT_OPTION_OUTPUT_OMIT_EXPERIMENT_IDENTIFIER = "oo";
    public static final String SHORT_OPTION_DEBUG = "d";
    public static final String SHORT_OPTION_LOG_ERROR = "l";
    public static final String SHORT_OPTION_SHOW_EXPERIMENT_ARGUMENTS = "sa";
    public static final String SHORT_OPTION_SHOW_TASKS = "st";
    public static final String SHORT_OPTION_HELP = "h";
    public static final String SHORT_OPTION_VERSION = "v";
    private static final String LONG_OPTION_HELP = "help";
    private static final String LONG_OPTION_VERSION = "version";
    private static final String LONG_OPTION_LOG_ERROR = "logError";
    private static final String LONG_OPTION_SHOW_EXPERIMENT_ARGUMENTS = "showArguments";
    private static final String LONG_OPTION_SHOW_TASKS = "showTasks";
    private static final String LONG_OPTION_DEBUG = "debug";
    private static final String LONG_OPTION_INPUT = "input";
    private static final String LONG_OPTION_INPUT_COPY_NON_INPUTS = "inputCopy";
    private static final String LONG_OPTION_INPUT_RELATIVE = "inputRelative";
    private static final String LONG_OPTION_INPUT_SUBSET_IDENTIFIER = "inputSubsetIdentifier";
    private static final String LONG_OPTION_INPUT_SHUFFLE = "inputShuffle";
    private static final String LONG_OPTION_INPUT_LIMIT = "inputLimit";
    public static final String LONG_OPTION_INPUT_RANDOM_SAMPLE = "inputRandom";
    public static final String LONG_OPTION_OUTPUT = "output";
    public static final String LONG_OPTION_OUTPUT_CONSOLE_ONLY = "outputConsoleOnly";
    private static final String LONG_OPTION_OUTPUT_ENABLE_ADDITIONAL = "outputEnable";
    private static final String LONG_OPTION_OUTPUT_DISABLE_ADDITIONAL = "outputDisable";
    private static final String LONG_OPTION_OUTPUT_ENABLE_ALL = "outputEnableAll";
    private static final String LONG_OPTION_OUTPUT_IMAGE_FILE_FORMAT = "outputFileFormat";
    private static final String LONG_OPTION_OUTPUT_INCREMENTING_NUMBER = "outputIncrementingNumber";
    private static final String LONG_OPTION_OUTPUT_SUPPRESS_DIRECTORIES = "outputSuppressDirectories";
    private static final String LONG_OPTION_OUTPUT_OMIT_EXPERIMENT_IDENTIFIER = "outputOmitExperimentIdentifier";
    private static final String LONG_OPTION_TASK = "task";
    private static final String LONG_OPTION_TASK_NUMBER_PROCESSORS = "taskNumberProcessors";
    private static final String LONG_OPTION_TASK_SIZE = "paramSize";
    public static final String LONG_OPTION_GROUP = "paramGroup";

    public static void addBasicOptions(Options options) {
        options.addOption(SHORT_OPTION_HELP, LONG_OPTION_HELP, false, "print this message and exit");
        options.addOption(SHORT_OPTION_VERSION, LONG_OPTION_VERSION, false, "print version information and exit");
        options.addOption(SHORT_OPTION_LOG_ERROR, LONG_OPTION_LOG_ERROR, true, "log BeanXML parsing errors to file");
        options.addOption(SHORT_OPTION_SHOW_EXPERIMENT_ARGUMENTS, LONG_OPTION_SHOW_EXPERIMENT_ARGUMENTS, false, "print experiment path arguments");
        options.addOption(SHORT_OPTION_SHOW_TASKS, LONG_OPTION_SHOW_TASKS, false, "print task-names as useful for -t <name>");
    }

    public static void addAdditionalOptions(Options options) {
        options.addOption(CustomArgumentOptions.optionalStringArgument(SHORT_OPTION_DEBUG, LONG_OPTION_DEBUG, "enables debug mode"));
        CommandLineOptions.addInputOptions(options);
        CommandLineOptions.addOutputOptions(options);
        CommandLineOptions.addTaskOptions(options);
    }

    public static void addInputOptions(Options options) {
        options.addOption(CustomArgumentOptions.requiredStringArgument(SHORT_OPTION_INPUT, LONG_OPTION_INPUT, "an input-directory OR glob (e.g. small_*.jpg) OR file extension (e.g. .png) OR path to BeanXML"));
        options.addOption(SHORT_OPTION_INPUT_COPY_NON_INPUTS, LONG_OPTION_INPUT_COPY_NON_INPUTS, false, "copies any unused files (as inputs) to the output directory");
        options.addOption(SHORT_OPTION_INPUT_RELATIVE_PATH, LONG_OPTION_INPUT_RELATIVE, false, "derives identifier from relative filename or path");
        options.addOption(SHORT_OPTION_INPUT_SUBSET_IDENTIFIER, LONG_OPTION_INPUT_SUBSET_IDENTIFIER, true, "subsets the identifier e.g. 2 OR -2 OR 3:-2 OR 2: OR :2 (zero-indexed, negatives count backwards)");
        options.addOption(SHORT_OPTION_INPUT_SHUFFLE, LONG_OPTION_INPUT_SHUFFLE, false, "shuffles (randomizes) the order of the inputs");
        options.addOption(SHORT_OPTION_INPUT_LIMIT, LONG_OPTION_INPUT_LIMIT, true, "imposes upper limit on number of inputs");
        options.addOption(SHORT_OPTION_INPUT_RANDOM_SAMPLE, LONG_OPTION_INPUT_RANDOM_SAMPLE, true, "randomly samples a number/portion of inputs");
    }

    private static void addOutputOptions(Options options) {
        options.addOption(CustomArgumentOptions.requiredStringArgument(SHORT_OPTION_OUTPUT, LONG_OPTION_OUTPUT, "an output-directory OR path to BeanXML"));
        options.addOption(CustomArgumentOptions.requiredStringArgument(SHORT_OPTION_OUTPUT_ENABLE_ADDITIONAL, LONG_OPTION_OUTPUT_ENABLE_ADDITIONAL, "enables specific additional output(s)"));
        options.addOption(CustomArgumentOptions.requiredStringArgument(SHORT_OPTION_OUTPUT_DISABLE_ADDITIONAL, LONG_OPTION_OUTPUT_DISABLE_ADDITIONAL, "disables specific additional output(s)"));
        options.addOption(SHORT_OPTION_OUTPUT_ENABLE_ALL, LONG_OPTION_OUTPUT_ENABLE_ALL, false, "enables all outputs");
        options.addOption(SHORT_OPTION_OUTPUT_CONSOLE_ONLY, LONG_OPTION_OUTPUT_CONSOLE_ONLY, false, "disables opening the output directory in the desktop");
        options.addOption(CustomArgumentOptions.optionalStringArgument(SHORT_OPTION_OUTPUT_IMAGE_FILE_FORMAT, LONG_OPTION_OUTPUT_IMAGE_FILE_FORMAT, "suggested image-format for writing"));
        options.addOption(SHORT_OPTION_OUTPUT_INCREMENTING_NUMBER, LONG_OPTION_OUTPUT_INCREMENTING_NUMBER, false, "outputs with incrementing number sequence");
        options.addOption(SHORT_OPTION_OUTPUT_SUPPRESS_DIRECTORIES, LONG_OPTION_OUTPUT_SUPPRESS_DIRECTORIES, false, "supresses subdirectory in output file identifiers");
        options.addOption(SHORT_OPTION_OUTPUT_OMIT_EXPERIMENT_IDENTIFIER, LONG_OPTION_OUTPUT_OMIT_EXPERIMENT_IDENTIFIER, true, "like -o but omits experiment name and version in output directory");
    }

    private static void addTaskOptions(Options options) {
        options.addOption(CustomArgumentOptions.optionalStringArgument(SHORT_OPTION_TASK, LONG_OPTION_TASK, "a task-name OR path to BeanXML"));
        options.addOption(CustomArgumentOptions.requiredStringArgument(SHORT_OPTION_TASK_SIZE, LONG_OPTION_TASK_SIZE, "suggests an image size or scaling factor"));
        options.addOption(CustomArgumentOptions.optionalStringArgument(SHORT_OPTION_GROUP, LONG_OPTION_GROUP, "groups inputs by subsetting the identifier e.g. 2 OR -2 OR 3:-2 OR 2: OR :2 (zero-indexed, negatives count backwards)"));
        options.addOption(CustomArgumentOptions.requiredNumberArgument(SHORT_OPTION_TASK_NUMBER_PROCESSORS, LONG_OPTION_TASK_NUMBER_PROCESSORS, "suggests a maximum number of CPU processors"));
    }

    @Generated
    private CommandLineOptions() {
    }
}

