/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.options.process;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.index.range.IndexRangeNegativeFactory;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.InputArguments;
import org.anchoranalysis.launcher.options.CommandLineExtracter;
import org.anchoranalysis.launcher.options.process.AddOptionsFromCommandLine;

public class AddInputOptions
extends AddOptionsFromCommandLine<InputArguments> {
    private static final String EXCEPTION_MESSAGE_PREFIX = "The -il option must be either a positive integer or a ratio in the interval (0.0, 1.0), but is";

    private AddInputOptions(CommandLineExtracter extract, InputArguments arguments) {
        super(extract, arguments);
    }

    public static void addFrom(CommandLineExtracter extract, InputArguments arguments) throws ExperimentExecutionException {
        new AddInputOptions(extract, arguments).addOptionsFromCommandLine();
    }

    @Override
    public void addOptionsFromCommandLine() throws ExperimentExecutionException {
        this.ifOptionWithoutArgument("ic", InputArguments::assignCopyNonInputs);
        this.ifOptionWithoutArgument("ip", arguments -> arguments.getContextParameters().assignRelativeForIdentifier());
        this.ifOptionWithoutArgument("is", arguments -> arguments.getContextParameters().assignShuffle());
        this.ifPresentSingleAssociated("ii", AddInputOptions::assignIdentifierSubrange);
        this.ifPresentSingleAssociated("il", AddInputOptions::assignLimit);
        this.ifPresentSingleAssociated("ir", AddInputOptions::assignRandomSample);
    }

    private static void assignRandomSample(InputArguments arguments, String parameter) throws ExperimentExecutionException {
        arguments.getContextParameters().assignShuffle();
        AddInputOptions.assignLimit(arguments, parameter);
    }

    private static void assignIdentifierSubrange(InputArguments arguments, String parameter) throws ExperimentExecutionException {
        try {
            arguments.getContextParameters().assignIdentifierSubrange(IndexRangeNegativeFactory.parse((String)parameter));
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException("Cannot set parameter for subsetting names.", (Throwable)e);
        }
    }

    private static void assignLimit(InputArguments arguments, String parameter) throws ExperimentExecutionException {
        try {
            int limit = Integer.parseInt(parameter);
            if (limit <= 0) {
                throw new ExperimentExecutionException(String.format("%s %d", EXCEPTION_MESSAGE_PREFIX, limit));
            }
            arguments.getContextParameters().assignFixedLimit(limit);
        }
        catch (NumberFormatException e) {
            double ratio = AddInputOptions.parseAsRatio(parameter);
            arguments.getContextParameters().assignRatioLimit(ratio);
        }
    }

    private static double parseAsRatio(String parameter) throws ExperimentExecutionException {
        try {
            double limit = Double.parseDouble(parameter);
            if (limit <= 0.0 || limit >= 1.0) {
                throw new ExperimentExecutionException(String.format("%s %f", EXCEPTION_MESSAGE_PREFIX, limit));
            }
            return limit;
        }
        catch (NumberFormatException e) {
            throw new ExperimentExecutionException("The -il option is an invalid number");
        }
    }
}

