/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.options.process;

import java.util.function.BiConsumer;
import org.anchoranalysis.core.format.FileFormatFactory;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.functional.checked.CheckedConsumer;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.OutputArguments;
import org.anchoranalysis.io.output.bean.rules.Permissive;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.recorded.OutputEnabledDelta;
import org.anchoranalysis.launcher.options.CommandLineExtracter;
import org.anchoranalysis.launcher.options.process.AddOptionsFromCommandLine;
import org.anchoranalysis.launcher.options.process.AdditionalOutputsParser;

public class AddOutputOptions
extends AddOptionsFromCommandLine<OutputArguments> {
    private AddOutputOptions(CommandLineExtracter extract, OutputArguments arguments) {
        super(extract, arguments);
    }

    public static void addFrom(CommandLineExtracter extract, OutputArguments arguments) throws ExperimentExecutionException {
        new AddOutputOptions(extract, arguments).addOptionsFromCommandLine();
    }

    @Override
    public void addOptionsFromCommandLine() throws ExperimentExecutionException {
        if (!this.ifOptionWithoutArgument("oa", outputArguments -> outputArguments.getOutputEnabledDelta().enableAdditionalOutputs(Permissive.INSTANCE))) {
            this.ifAdditionalOptionsPresent("oe", OutputEnabledDelta::enableAdditionalOutputs);
        }
        this.ifAdditionalOptionsPresent("od", OutputEnabledDelta::disableAdditionalOutputs);
        this.ifOutputFormatPresent("of", OutputArguments::assignSuggestedImageOutputFormat);
        this.ifOptionWithoutArgument("on", OutputArguments::requestOutputIncrementingNumberSequence);
        this.ifOptionWithoutArgument("os", OutputArguments::requestOutputSuppressDirectories);
        this.ifPresentSingleAssociated("oo", OutputArguments::requestOmitExperimentIdentifier);
    }

    private void ifAdditionalOptionsPresent(String optionName, BiConsumer<OutputEnabledDelta, MultiLevelOutputEnabled> function) throws ExperimentExecutionException {
        this.ifPresentMultiple(optionName, (CheckedConsumer<String[], ExperimentExecutionException>)((CheckedConsumer)outputs -> function.accept(((OutputArguments)this.associated).getOutputEnabledDelta(), (MultiLevelOutputEnabled)AdditionalOutputsParser.parseFrom(outputs, optionName))));
    }

    private void ifOutputFormatPresent(String optionName, BiConsumer<OutputArguments, ImageFileFormat> consumer) throws ExperimentExecutionException {
        this.ifPresentSingle(optionName, (CheckedConsumer<String, ExperimentExecutionException>)((CheckedConsumer)identifier -> {
            ImageFileFormat format = (ImageFileFormat)FileFormatFactory.createImageFormat((String)identifier).orElseThrow(() -> new ExperimentExecutionException(String.format("No file format identified by %s is supported.", identifier)));
            consumer.accept((OutputArguments)this.associated, format);
        }));
    }
}

