/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.launcher.options.process;

import lombok.Generated;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;

class AdditionalOutputsParser {
    private static final String ELEMENT_SEPERATOR = ":";
    private static final String EXCEPTION_MESSAGE_SNIPPET = "It must be in the format of either outputName or firstLevelOutputName:secondLevelOutputName.";

    public static OutputEnabledMutable parseFrom(String[] optionsArgument, String optionName) throws ExperimentExecutionException {
        OutputEnabledMutable outputs = new OutputEnabledMutable(new String[0]);
        for (String argument : optionsArgument) {
            if (argument.isEmpty()) {
                throw new ExperimentExecutionException(String.format("The -%s option requires an argument.", optionName));
            }
            for (String element : argument.split(",")) {
                AdditionalOutputsParser.addElement(outputs, element);
            }
        }
        return outputs;
    }

    private static void addElement(OutputEnabledMutable outputs, String element) throws ExperimentExecutionException {
        if (element.contains(ELEMENT_SEPERATOR)) {
            AdditionalOutputsParser.addSecondLevelElement(outputs, element);
        } else {
            outputs.addEnabledOutputFirst(new String[]{element});
        }
    }

    private static void addSecondLevelElement(OutputEnabledMutable outputs, String element) throws ExperimentExecutionException {
        if (element.startsWith(ELEMENT_SEPERATOR) || element.endsWith(ELEMENT_SEPERATOR)) {
            throw AdditionalOutputsParser.createException("An output-name may not start or end with a colon.", element);
        }
        String[] splits = element.split(ELEMENT_SEPERATOR);
        if (splits.length != 2) {
            throw AdditionalOutputsParser.createException("Invalid output-name.", element);
        }
        outputs.addEnabledOutputSecond(splits[0], new String[]{splits[1]});
    }

    private static ExperimentExecutionException createException(String prefix, String element) {
        return new ExperimentExecutionException(String.format("%s%n%s%n%s", prefix, EXCEPTION_MESSAGE_SNIPPET, element));
    }

    @Generated
    private AdditionalOutputsParser() {
    }
}

